/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;

public class TransactionRangeDiagnostics
extends NamedDiagnosticsProvider {
    private final Database database;

    TransactionRangeDiagnostics(Database database) {
        super("Transaction log");
        this.database = database;
    }

    public void dump(DiagnosticsLogger logger) {
        LogFiles logFiles = (LogFiles)this.database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        try {
            logger.log("Transaction log files stored on file store: " + FileUtils.getFileStoreType((Path)logFiles.logFilesDirectory()));
            long logVersion = logFile.getLowestLogVersion();
            while (logFile.versionExists(logVersion)) {
                if (logFile.hasAnyEntries(logVersion)) {
                    LogHeader header = logFile.extractHeader(logVersion);
                    long firstTransactionIdInThisLog = header.getLastCommittedTxId() + 1L;
                    logger.log("Oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                    return;
                }
                ++logVersion;
            }
            logger.log("No transactions found in any log");
        }
        catch (IOException e) {
            logger.log("Error trying to dump transaction log files info.");
            logger.log(Exceptions.stringify((Throwable)e));
        }
    }
}

