/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Iterator;
import java.util.function.IntUnaryOperator;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.kernel.impl.util.collection.LongProbeTable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class EagerBuffer<T extends Measurable>
extends DefaultCloseListenable {
    public static final IntUnaryOperator KEEP_CONSTANT_CHUNK_SIZE = size -> size;
    public static final IntUnaryOperator GROW_NEW_CHUNKS_BY_50_PCT = size -> size + (size >> 1);
    public static final IntUnaryOperator GROW_NEW_CHUNKS_BY_100_PCT = size -> size << 1;
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(EagerBuffer.class);
    private final MemoryTracker scopedMemoryTracker;
    private final IntUnaryOperator growthStrategy;
    private Chunk<T> first;
    private Chunk<T> current;
    private long size;
    private int maxChunkSize;

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker) {
        return EagerBuffer.createEagerBuffer(memoryTracker, 1024, 0x7FFFFFF7, GROW_NEW_CHUNKS_BY_50_PCT);
    }

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker, int initialChunkSize) {
        return EagerBuffer.createEagerBuffer(memoryTracker, initialChunkSize, 0x7FFFFFF7, GROW_NEW_CHUNKS_BY_50_PCT);
    }

    public static <T extends Measurable> EagerBuffer<T> createEagerBuffer(MemoryTracker memoryTracker, int initialChunkSize, int maxChunkSize, IntUnaryOperator growthStrategy) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + LongProbeTable.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE + HeapEstimator.shallowSizeOfInstance(IntUnaryOperator.class));
        return new EagerBuffer<T>(scopedMemoryTracker, initialChunkSize, maxChunkSize, growthStrategy);
    }

    private EagerBuffer(MemoryTracker scopedMemoryTracker, int initialChunkSize, int maxChunkSize, IntUnaryOperator growthStrategy) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.maxChunkSize = maxChunkSize;
        this.growthStrategy = growthStrategy;
        this.first = new Chunk(initialChunkSize, scopedMemoryTracker.getScopedMemoryTracker());
        this.current = this.first;
    }

    public void add(T element) {
        if (!this.current.add(element)) {
            int newChunkSize = this.grow(this.current.elements.length);
            Chunk newChunk = new Chunk(newChunkSize, this.scopedMemoryTracker.getScopedMemoryTracker());
            this.current.next = newChunk;
            this.current = newChunk;
            this.current.add(element);
        }
        ++this.size;
    }

    public long size() {
        return this.size;
    }

    public Iterator<T> autoClosingIterator() {
        return new Iterator<T>(){
            private Chunk<T> chunk;
            private int index;
            {
                this.chunk = EagerBuffer.this.first;
                EagerBuffer.this.first = null;
                EagerBuffer.this.current = null;
            }

            @Override
            public boolean hasNext() {
                if (this.chunk == null || this.index >= this.chunk.cursor) {
                    EagerBuffer.this.close();
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                Object element = this.chunk.elements[this.index++];
                if (this.index >= this.chunk.cursor) {
                    Chunk chunkToRelease = this.chunk;
                    this.chunk = this.chunk.next;
                    this.index = 0;
                    chunkToRelease.close();
                }
                return (Measurable)element;
            }
        };
    }

    public void closeInternal() {
        this.first = null;
        this.current = null;
        this.scopedMemoryTracker.close();
    }

    public boolean isClosed() {
        return false;
    }

    @VisibleForTesting
    int numberOfChunks() {
        int i = 0;
        Chunk<T> chunk = this.first;
        while (chunk != null) {
            chunk = chunk.next;
            ++i;
        }
        return i;
    }

    private int grow(int size) {
        if (size == this.maxChunkSize) {
            return size;
        }
        int newSize = this.growthStrategy.applyAsInt(size);
        if (newSize <= 0 || newSize > this.maxChunkSize) {
            return this.maxChunkSize;
        }
        return newSize;
    }

    private static class Chunk<T extends Measurable> {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Chunk.class);
        private final Object[] elements;
        private Chunk<T> next;
        private MemoryTracker memoryTracker;
        private int cursor;

        Chunk(int size, MemoryTracker memoryTracker) {
            memoryTracker.allocateHeap(SHALLOW_SIZE + LongProbeTable.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)size));
            this.elements = new Object[size];
            this.memoryTracker = memoryTracker;
        }

        boolean add(T element) {
            if (this.cursor < this.elements.length) {
                this.memoryTracker.allocateHeap(element.estimatedHeapUsage());
                this.elements[this.cursor++] = element;
                return true;
            }
            return false;
        }

        void close() {
            this.memoryTracker.close();
        }
    }
}

