/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.io.IOException;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelViewNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipTypeViewRelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.util.FeatureToggles;

public class DynamicIndexStoreView
implements IndexStoreView {
    private static final boolean USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION = FeatureToggles.flag(DynamicIndexStoreView.class, (String)"use.label.index", (boolean)true);
    private final NeoStoreIndexStoreView neoStoreIndexStoreView;
    private final LabelScanStore labelScanStore;
    private final RelationshipTypeScanStore relationshipTypeScanStore;
    protected final LockService locks;
    private final Log log;
    private final Config config;
    protected final Supplier<StorageReader> storageEngine;

    public DynamicIndexStoreView(NeoStoreIndexStoreView neoStoreIndexStoreView, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, LockService locks, Supplier<StorageReader> storageEngine, LogProvider logProvider, Config config) {
        this.neoStoreIndexStoreView = neoStoreIndexStoreView;
        this.labelScanStore = labelScanStore;
        this.relationshipTypeScanStore = relationshipTypeScanStore;
        this.locks = locks;
        this.storageEngine = storageEngine;
        this.log = logProvider.getLog(this.getClass());
        this.config = config;
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (forceStoreScan || !USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION || this.useAllNodeStoreScan(labelIds, cursorTracer)) {
            return this.neoStoreIndexStoreView.visitNodes(labelIds, propertyKeyIdFilter, propertyUpdatesVisitor, labelUpdateVisitor, forceStoreScan, cursorTracer, memoryTracker);
        }
        return new LabelViewNodeStoreScan<FAILURE>(this.storageEngine.get(), this.locks, this.labelScanStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, cursorTracer, memoryTracker);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor, Visitor<EntityTokenUpdate, FAILURE> relationshipTypeUpdateVisitor, boolean forceStoreScan, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (forceStoreScan || this.useAllRelationshipStoreScan(relationshipTypeIds, cursorTracer)) {
            return this.neoStoreIndexStoreView.visitRelationships(relationshipTypeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, memoryTracker);
        }
        return new RelationshipTypeViewRelationshipStoreScan<FAILURE>(this.storageEngine.get(), this.locks, this.relationshipTypeScanStore, relationshipTypeUpdateVisitor, propertyUpdateVisitor, relationshipTypeIds, propertyKeyIdFilter, cursorTracer, memoryTracker);
    }

    @Override
    public boolean isEmpty() {
        return this.neoStoreIndexStoreView.isEmpty();
    }

    private boolean useAllNodeStoreScan(int[] labelIds, PageCursorTracer cursorTracer) {
        try {
            return ArrayUtils.isEmpty((int[])labelIds) || this.isEmptyLabelScanStore(cursorTracer);
        }
        catch (Exception e) {
            this.log.error("Cannot determine number of labeled nodes, falling back to all nodes scan.", (Throwable)e);
            return true;
        }
    }

    private boolean useAllRelationshipStoreScan(int[] relationshipTypeIds, PageCursorTracer cursorTracer) {
        try {
            return (Boolean)this.config.get(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store) == false || ArrayUtils.isEmpty((int[])relationshipTypeIds) || this.isEmptyRelationshipTypeStoreScan(cursorTracer);
        }
        catch (Exception e) {
            this.log.error("Cannot determine number of relationships in scan store, falling back to all relationships scan.", (Throwable)e);
            return true;
        }
    }

    private boolean isEmptyLabelScanStore(PageCursorTracer cursorTracer) throws Exception {
        return this.labelScanStore.isEmpty(cursorTracer);
    }

    private boolean isEmptyRelationshipTypeStoreScan(PageCursorTracer cursorTracer) throws IOException {
        return this.relationshipTypeScanStore.isEmpty(cursorTracer);
    }

    @Override
    public NodePropertyAccessor newPropertyAccessor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.neoStoreIndexStoreView.newPropertyAccessor(cursorTracer, memoryTracker);
    }
}

