/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class StatementQueryRegistry
implements QueryRegistry {
    private final KernelStatement statement;
    private final ExecutingQueryFactory factory;

    StatementQueryRegistry(KernelStatement statement, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, Config config) {
        this.statement = statement;
        this.factory = new ExecutingQueryFactory(clock, cpuClockRef, config);
    }

    @Override
    public Optional<ExecutingQuery> executingQuery() {
        return this.statement.executingQuery();
    }

    @Override
    public void registerExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.startQueryExecution(executingQuery);
    }

    @Override
    public ExecutingQuery startQueryExecution(String queryText, MapValue queryParameters) {
        ExecutingQuery executingQuery = this.factory.createForStatement(this.statement, queryText, queryParameters);
        this.registerExecutingQuery(executingQuery);
        return executingQuery;
    }

    @Override
    public void startQueryExecution(ExecutingQuery executingQuery) {
        this.factory.bindToStatement(executingQuery, this.statement);
        this.registerExecutingQuery(executingQuery);
    }

    @Override
    public void unregisterExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.stopQueryExecution(executingQuery);
    }
}

