/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.stream.LongStream;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.util.Preconditions;

public class ThresholdBasedPruneStrategy
implements LogPruneStrategy {
    private final LogFile logFile;
    private final Threshold threshold;
    private final TransactionLogFileInformation logFileInformation;

    ThresholdBasedPruneStrategy(LogFile logFile, Threshold threshold) {
        this.logFile = logFile;
        this.logFileInformation = logFile.getLogFileInformation();
        this.threshold = threshold;
    }

    public String toString() {
        return this.threshold.toString();
    }

    @Override
    public synchronized LongStream findLogVersionsToDelete(long upToVersion) {
        if (upToVersion == 0L) {
            return LongStream.empty();
        }
        this.threshold.init();
        long lowestLogVersion = this.logFile.getLowestLogVersion();
        ThresholdEvaluationResult thresholdResult = this.pruneThresholdReached(upToVersion, lowestLogVersion);
        if (!thresholdResult.reached()) {
            return LongStream.empty();
        }
        return LongStream.rangeClosed(lowestLogVersion, Math.min(thresholdResult.logVersion(), upToVersion - 2L));
    }

    private ThresholdEvaluationResult pruneThresholdReached(long upToVersion, long lowestLogVersion) {
        for (long version = upToVersion - 1L; version >= lowestLogVersion; --version) {
            if (!this.threshold.reached(this.logFile.getLogFileForVersion(version), version, this.logFileInformation)) continue;
            return ThresholdEvaluationResult.reached(version);
        }
        return ThresholdEvaluationResult.notReached();
    }

    private static class ThresholdEvaluationResult {
        private static final int NON_EXISTING_LOG_VERSION = -1;
        private final long logVersion;

        private static ThresholdEvaluationResult notReached() {
            return new ThresholdEvaluationResult();
        }

        private static ThresholdEvaluationResult reached(long version) {
            Preconditions.requireNonNegative((long)version);
            return new ThresholdEvaluationResult(version);
        }

        private ThresholdEvaluationResult() {
            this(-1L);
        }

        private ThresholdEvaluationResult(long logVersion) {
            this.logVersion = logVersion;
        }

        boolean reached() {
            return this.logVersion != -1L;
        }

        long logVersion() {
            return this.logVersion;
        }
    }
}

