/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;

public final class FileSizeThreshold
implements Threshold {
    private final FileSystemAbstraction fileSystem;
    private final long maxSize;
    private long currentSize;

    FileSizeThreshold(FileSystemAbstraction fileSystem, long maxSize) {
        this.fileSystem = fileSystem;
        this.maxSize = maxSize;
    }

    @Override
    public void init() {
        this.currentSize = 0L;
    }

    @Override
    public boolean reached(Path file, long version, LogFileInformation source) {
        this.currentSize += this.fileSystem.getFileSize(file);
        return this.currentSize >= this.maxSize;
    }

    public String toString() {
        return this.maxSize + " size";
    }
}

