/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTraversalCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;

public class DefaultThreadSafeCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;

    public DefaultThreadSafeCursors(StorageReader storageReader) {
        super(new ConcurrentLinkedQueue<DefaultCursors.CloseableStacktrace>());
        this.storageReader = storageReader;
    }

    public DefaultNodeCursor allocateNodeCursor(PageCursorTracer cursorTracer) {
        return this.trace(new DefaultNodeCursor(DefaultNodeCursor::release, this.storageReader.allocateNodeCursor(cursorTracer), this.storageReader.allocateNodeCursor(cursorTracer)));
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor(PageCursorTracer cursorTracer) {
        return this.trace(new FullAccessNodeCursor(DefaultNodeCursor::release, this.storageReader.allocateNodeCursor(cursorTracer)));
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor(PageCursorTracer cursorTracer) {
        return this.trace(new DefaultRelationshipScanCursor(DefaultRelationshipScanCursor::release, this.storageReader.allocateRelationshipScanCursor(cursorTracer), this.allocateNodeCursor(cursorTracer)));
    }

    public FullAccessRelationshipScanCursor allocateFullAccessRelationshipScanCursor(PageCursorTracer cursorTracer) {
        return this.trace(new FullAccessRelationshipScanCursor(DefaultRelationshipScanCursor::release, this.storageReader.allocateRelationshipScanCursor(cursorTracer)));
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        return this.trace(new DefaultRelationshipTraversalCursor(DefaultRelationshipTraversalCursor::release, this.storageReader.allocateRelationshipTraversalCursor(cursorTracer), this.allocateNodeCursor(cursorTracer)));
    }

    public DefaultRelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        return this.trace(new FullAccessRelationshipTraversalCursor(DefaultRelationshipTraversalCursor::release, this.storageReader.allocateRelationshipTraversalCursor(cursorTracer)));
    }

    public PropertyCursor allocatePropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.trace(new DefaultPropertyCursor(DefaultPropertyCursor::release, this.storageReader.allocatePropertyCursor(cursorTracer, memoryTracker), this.allocateFullAccessNodeCursor(cursorTracer), this.allocateFullAccessRelationshipScanCursor(cursorTracer)));
    }

    public PropertyCursor allocateFullAccessPropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.trace(new FullAccessPropertyCursor(DefaultPropertyCursor::release, this.storageReader.allocatePropertyCursor(cursorTracer, memoryTracker)));
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.trace(new DefaultNodeValueIndexCursor(DefaultNodeValueIndexCursor::release, this.allocateNodeCursor(cursorTracer), memoryTracker));
    }

    public NodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.trace(new FullAccessNodeValueIndexCursor(DefaultNodeValueIndexCursor::release, memoryTracker));
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        return this.trace(new DefaultNodeLabelIndexCursor(DefaultNodeLabelIndexCursor::release, this.allocateNodeCursor(cursorTracer)));
    }

    public NodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        return this.trace(new FullAccessNodeLabelIndexCursor(DefaultNodeLabelIndexCursor::release));
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor(PageCursorTracer cursorTracer) {
        return this.trace(new DefaultRelationshipIndexCursor(DefaultRelationshipIndexCursor::release, this.allocateRelationshipScanCursor(cursorTracer)));
    }

    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor() {
        return this.trace(new DefaultRelationshipTypeIndexCursor(DefaultRelationshipTypeIndexCursor::release));
    }

    public void close() {
        this.assertClosed();
        this.storageReader.close();
    }
}

