/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.Collection;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.service.Services;
import org.neo4j.util.VisibleForTesting;

public class StatementLocksFactorySelector {
    private final Locks locks;
    private final Config config;
    private final Log log;

    public StatementLocksFactorySelector(Locks locks, Config config, LogService logService) {
        this.locks = locks;
        this.config = config;
        this.log = logService.getInternalLog(this.getClass());
    }

    public StatementLocksFactory select() {
        StatementLocksFactory statementLocksFactory;
        String serviceName = StatementLocksFactory.class.getSimpleName();
        Collection<StatementLocksFactory> factories = this.serviceLoadFactories();
        if (factories.isEmpty()) {
            statementLocksFactory = new SimpleStatementLocksFactory();
            this.log.info("No services implementing " + serviceName + " found. Using " + SimpleStatementLocksFactory.class.getSimpleName());
        } else if (factories.size() == 1) {
            statementLocksFactory = (StatementLocksFactory)Iterables.first(factories);
            this.log.info("Found single implementation of " + serviceName + ". Namely " + statementLocksFactory.getClass().getSimpleName());
        } else {
            throw new IllegalStateException("Found more than one implementation of " + serviceName + ": " + factories);
        }
        statementLocksFactory.initialize(this.locks, this.config);
        return statementLocksFactory;
    }

    @VisibleForTesting
    Collection<StatementLocksFactory> serviceLoadFactories() {
        return Services.loadAll(StatementLocksFactory.class);
    }
}

