/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.EntityLocker;
import org.neo4j.kernel.impl.coreapi.EntityValidationTransactionImpl;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.internal.NodeCursorResourceIterator;
import org.neo4j.kernel.impl.coreapi.internal.NodeLabelPropertyIterator;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class TransactionImpl
extends EntityValidationTransactionImpl {
    private static final EntityLocker locker = new EntityLocker();
    private final TokenHolders tokenHolders;
    private final TransactionalContextFactory contextFactory;
    private final DatabaseAvailabilityGuard availabilityGuard;
    private final QueryExecutionEngine executionEngine;
    private final Consumer<Status> terminationCallback;
    private final TransactionExceptionMapper exceptionMapper;
    private KernelTransaction transaction;
    private boolean closed;
    private List<InternalTransaction.TransactionClosedCallback> closeCallbacks;

    public TransactionImpl(TokenHolders tokenHolders, TransactionalContextFactory contextFactory, DatabaseAvailabilityGuard availabilityGuard, QueryExecutionEngine executionEngine, KernelTransaction transaction, Consumer<Status> terminationCallback, TransactionExceptionMapper exceptionMapper) {
        this.tokenHolders = tokenHolders;
        this.contextFactory = contextFactory;
        this.availabilityGuard = availabilityGuard;
        this.executionEngine = executionEngine;
        this.terminationCallback = terminationCallback;
        this.exceptionMapper = exceptionMapper;
        this.setTransaction(transaction);
    }

    public void commit() {
        this.safeTerminalOperation(KernelTransaction::commit);
    }

    public void rollback() {
        if (this.isOpen()) {
            this.safeTerminalOperation(KernelTransaction::rollback);
        }
    }

    public Node createNode() {
        KernelTransaction ktx = this.kernelTransaction();
        try {
            return this.newNodeEntity(ktx.dataWrite().nodeCreate());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node createNode(Label ... labels) {
        KernelTransaction ktx = this.kernelTransaction();
        try {
            TokenWrite tokenWrite = ktx.tokenWrite();
            int[] labelIds = new int[labels.length];
            String[] labelNames = new String[labels.length];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = labels[i].name();
            }
            tokenWrite.labelGetOrCreateForNames(labelNames, labelIds);
            Write write = ktx.dataWrite();
            long nodeId = write.nodeCreateWithLabels(labelIds);
            return this.newNodeEntity(nodeId);
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node getNodeById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, id));
        }
        KernelTransaction ktx = this.kernelTransaction();
        if (!ktx.dataRead().nodeExists(id)) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, id));
        }
        return this.newNodeEntity(id);
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        return this.execute(this, query, ValueUtils.asParameterMapValue(parameters));
    }

    private Result execute(InternalTransaction transaction, String query, MapValue parameters) throws QueryExecutionException {
        this.checkInTransaction();
        TransactionalContext context = this.contextFactory.newContext(transaction, query, parameters);
        try {
            this.availabilityGuard.assertDatabaseAvailable();
            return this.executionEngine.executeQuery(query, parameters, context, false);
        }
        catch (UnavailableException ue) {
            throw new TransactionFailureException(ue.getMessage(), (Throwable)ue);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, id));
        }
        KernelTransaction ktx = this.kernelTransaction();
        if (!ktx.dataRead().relationshipExists(id)) {
            throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, id));
        }
        return this.newRelationshipEntity(id);
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        this.checkInTransaction();
        return new BidirectionalTraversalDescriptionImpl();
    }

    public TraversalDescription traversalDescription() {
        this.checkInTransaction();
        return new MonoDirectionalTraversalDescription();
    }

    public Iterable<Label> getAllLabelsInUse() {
        return this.allInUse(TokenAccess.LABELS);
    }

    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.allInUse(TokenAccess.RELATIONSHIP_TYPES);
    }

    public Iterable<Label> getAllLabels() {
        return this.all(TokenAccess.LABELS);
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.all(TokenAccess.RELATIONSHIP_TYPES);
    }

    public Iterable<String> getAllPropertyKeys() {
        return this.all(TokenAccess.PROPERTY_KEYS);
    }

    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple nodes with label: '%s', property name: '%s' and property value: '%s' while only one was expected.", myLabel, key, value));
            }
            Node node2 = node;
            return node2;
        }
    }

    public ResourceIterator<Node> findNodes(Label myLabel) {
        return this.allNodesWithLabel(myLabel);
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        return this.nodesByLabelAndProperty(transaction, labelId, (IndexQuery)IndexQuery.exact((int)propertyId, (Object)Values.of((Object)value)));
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, String value, StringSearchMode searchMode) {
        IndexQuery.ExactPredicate query;
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        switch (searchMode) {
            case EXACT: {
                query = IndexQuery.exact((int)propertyId, (Object)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
                break;
            }
            case PREFIX: {
                query = IndexQuery.stringPrefix((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
                break;
            }
            case SUFFIX: {
                query = IndexQuery.stringSuffix((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
                break;
            }
            case CONTAINS: {
                query = IndexQuery.stringContains((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown string search mode: " + searchMode);
            }
        }
        return this.nodesByLabelAndProperty(transaction, labelId, (IndexQuery)query);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(transaction, labelId, IndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1)), IndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2)), IndexQuery.exact((int)tokenRead.propertyKey(key3), (Object)Values.of((Object)value3)));
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(transaction, labelId, IndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1)), IndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2)));
    }

    public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        KernelTransaction transaction = this.kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        IndexQuery.ExactPredicate[] queries = new IndexQuery.ExactPredicate[propertyValues.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            queries[i++] = IndexQuery.exact((int)tokenRead.propertyKey(entry.getKey()), (Object)Values.of((Object)entry.getValue()));
        }
        return this.nodesByLabelAndProperties(transaction, labelId, queries);
    }

    public ResourceIterable<Node> getAllNodes() {
        KernelTransaction ktx = this.kernelTransaction();
        return () -> {
            final NodeCursor cursor = ktx.cursors().allocateNodeCursor(ktx.pageCursorTracer());
            ktx.dataRead().allNodesScan(cursor);
            return new PrefetchingResourceIterator<Node>(){

                protected Node fetchNextOrNull() {
                    if (cursor.next()) {
                        return TransactionImpl.this.newNodeEntity(cursor.nodeReference());
                    }
                    this.close();
                    return null;
                }

                public void close() {
                    cursor.close();
                }
            };
        };
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        KernelTransaction ktx = this.kernelTransaction();
        return () -> {
            final RelationshipScanCursor cursor = ktx.cursors().allocateRelationshipScanCursor(ktx.pageCursorTracer());
            ktx.dataRead().allRelationshipsScan(cursor);
            return new PrefetchingResourceIterator<Relationship>(){

                protected Relationship fetchNextOrNull() {
                    if (cursor.next()) {
                        return TransactionImpl.this.newRelationshipEntity(cursor.relationshipReference(), cursor.sourceNodeReference(), cursor.type(), cursor.targetNodeReference());
                    }
                    this.close();
                    return null;
                }

                public void close() {
                    cursor.close();
                }
            };
        };
    }

    public final void terminate() {
        this.terminate((Status)Status.Transaction.Terminated);
    }

    public void terminate(Status reason) {
        KernelTransaction ktx = this.transaction;
        if (ktx == null) {
            return;
        }
        ktx.markForTermination(reason);
        if (this.terminationCallback != null) {
            this.terminationCallback.accept(reason);
        }
    }

    public UUID getDatabaseId() {
        if (this.transaction != null) {
            return this.transaction.getDatabaseId();
        }
        return null;
    }

    public String getDatabaseName() {
        if (this.transaction != null) {
            return this.transaction.getDatabaseName();
        }
        return null;
    }

    public void close() {
        if (this.isOpen()) {
            this.safeTerminalOperation(KernelTransaction::close);
        }
    }

    public void addCloseCallback(InternalTransaction.TransactionClosedCallback callback) {
        if (this.closeCallbacks == null) {
            this.closeCallbacks = new ArrayList<InternalTransaction.TransactionClosedCallback>(4);
        }
        this.closeCallbacks.add(callback);
    }

    private void safeTerminalOperation(TransactionalOperation operation) {
        try {
            if (this.closed) {
                throw new NotInTransactionException("The transaction has been closed.");
            }
            operation.perform(this.transaction);
            this.closed = true;
            this.transaction = null;
            if (this.closeCallbacks != null) {
                this.closeCallbacks.forEach(InternalTransaction.TransactionClosedCallback::transactionClosed);
            }
        }
        catch (Exception e) {
            throw this.exceptionMapper.mapException(e);
        }
    }

    public void setTransaction(KernelTransaction transaction) {
        this.transaction = transaction;
        transaction.bindToUserTransaction((InternalTransaction)this);
    }

    public Lock acquireWriteLock(Entity entity) {
        return locker.exclusiveLock(this.kernelTransaction(), entity);
    }

    public Lock acquireReadLock(Entity entity) {
        return locker.sharedLock(this.kernelTransaction(), entity);
    }

    public KernelTransaction kernelTransaction() {
        this.checkInTransaction();
        return this.transaction;
    }

    public KernelTransaction.Type transactionType() {
        return this.kernelTransaction().transactionType();
    }

    public SecurityContext securityContext() {
        return this.kernelTransaction().securityContext();
    }

    public ClientConnectionInfo clientInfo() {
        return this.kernelTransaction().clientInfo();
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.kernelTransaction().overrideWith(context);
    }

    public Optional<Status> terminationReason() {
        KernelTransaction tx = this.transaction;
        return tx != null ? tx.getReasonIfTerminated() : Optional.empty();
    }

    public void setMetaData(Map<String, Object> txMeta) {
        this.kernelTransaction().setMetaData(txMeta);
    }

    public RelationshipEntity newRelationshipEntity(long id) {
        return new RelationshipEntity(this, id);
    }

    public RelationshipEntity newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipEntity(this, id, startNodeId, typeId, endNodeId);
    }

    public NodeEntity newNodeEntity(long nodeId) {
        return new NodeEntity(this, nodeId);
    }

    public RelationshipType getRelationshipTypeById(int type) {
        try {
            String name = this.tokenHolders.relationshipTypeTokens().getTokenById(type).name();
            return RelationshipType.withName((String)name);
        }
        catch (TokenNotFoundException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type);
        }
    }

    public Schema schema() {
        return new SchemaImpl(this.kernelTransaction());
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(KernelTransaction transaction, int labelId, IndexQuery query) {
        Read read = transaction.dataRead();
        if (query.propertyKeyId() == -1 || labelId == -1) {
            return Iterators.emptyResourceIterator();
        }
        Iterator iterator = transaction.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{query.propertyKeyId()}));
        while (iterator.hasNext()) {
            IndexDescriptor index = (IndexDescriptor)iterator.next();
            if (index.getIndexType() != IndexType.BTREE) continue;
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.pageCursorTracer(), transaction.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.nodeIndexSeek(indexSession, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{query});
                return new NodeCursorResourceIterator<NodeValueIndexCursor>(cursor, this::newNodeEntity);
            }
            catch (KernelException kernelException) {
            }
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(labelId, query);
    }

    public void checkInTransaction() {
        if (this.closed) {
            throw new NotInTransactionException("The transaction has been closed.");
        }
        if (this.transaction.isTerminated()) {
            Status terminationReason = (Status)this.transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(int labelId, IndexQuery ... queries) {
        KernelTransaction transaction = this.kernelTransaction();
        NodeLabelIndexCursor nodeLabelCursor = transaction.cursors().allocateNodeLabelIndexCursor(transaction.pageCursorTracer());
        NodeCursor nodeCursor = transaction.cursors().allocateNodeCursor(transaction.pageCursorTracer());
        PropertyCursor propertyCursor = transaction.cursors().allocatePropertyCursor(transaction.pageCursorTracer(), transaction.memoryTracker());
        transaction.dataRead().nodeLabelScan(labelId, nodeLabelCursor, IndexOrder.NONE);
        return new NodeLabelPropertyIterator(transaction.dataRead(), nodeLabelCursor, nodeCursor, propertyCursor, this::newNodeEntity, queries);
    }

    private ResourceIterator<Node> nodesByLabelAndProperties(KernelTransaction transaction, int labelId, IndexQuery.ExactPredicate ... queries) {
        Read read = transaction.dataRead();
        if (TransactionImpl.isInvalidQuery(labelId, (IndexQuery[])queries)) {
            return Iterators.emptyResourceIterator();
        }
        int[] propertyIds = TransactionImpl.getPropertyIds((IndexQuery[])queries);
        IndexDescriptor index = TransactionImpl.findMatchingIndex(transaction, labelId, propertyIds);
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.pageCursorTracer(), transaction.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.nodeIndexSeek(indexSession, cursor, IndexQueryConstraints.unconstrained(), TransactionImpl.getReorderedIndexQueries(index.schema().getPropertyIds(), (IndexQuery[])queries));
                return new NodeCursorResourceIterator<NodeValueIndexCursor>(cursor, this::newNodeEntity);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(labelId, (IndexQuery[])queries);
    }

    private static IndexQuery[] getReorderedIndexQueries(int[] indexPropertyIds, IndexQuery[] queries) {
        IndexQuery[] orderedQueries = new IndexQuery[queries.length];
        block0: for (int i = 0; i < indexPropertyIds.length; ++i) {
            int propertyKeyId = indexPropertyIds[i];
            for (IndexQuery query : queries) {
                if (query.propertyKeyId() != propertyKeyId) continue;
                orderedQueries[i] = query;
                continue block0;
            }
        }
        return orderedQueries;
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        KernelTransaction ktx = this.kernelTransaction();
        int labelId = ktx.tokenRead().nodeLabel(myLabel.name());
        if (labelId == -1) {
            return Iterators.emptyResourceIterator();
        }
        NodeLabelIndexCursor cursor = ktx.cursors().allocateNodeLabelIndexCursor(this.transaction.pageCursorTracer());
        ktx.dataRead().nodeLabelScan(labelId, cursor, IndexOrder.NONE);
        return new NodeCursorResourceIterator<NodeLabelIndexCursor>(cursor, this::newNodeEntity);
    }

    private static IndexDescriptor findMatchingIndex(KernelTransaction transaction, int labelId, int[] propertyIds) {
        Iterator iterator = transaction.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyIds));
        while (iterator.hasNext()) {
            IndexDescriptor index = (IndexDescriptor)iterator.next();
            if (index.getIndexType() != IndexType.BTREE) continue;
            return index;
        }
        Arrays.sort(propertyIds);
        TransactionImpl.assertNoDuplicates(propertyIds, transaction.tokenRead());
        int[] workingCopy = new int[propertyIds.length];
        Iterator indexes = transaction.schemaRead().indexesGetForLabel(labelId);
        while (indexes.hasNext()) {
            IndexDescriptor index = (IndexDescriptor)indexes.next();
            int[] original = index.schema().getPropertyIds();
            if (index.getIndexType() != IndexType.BTREE || !TransactionImpl.hasSamePropertyIds(original, workingCopy, propertyIds)) continue;
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    private static void assertNoDuplicates(int[] propertyIds, TokenRead tokenRead) {
        int prev = propertyIds[0];
        for (int i = 1; i < propertyIds.length; ++i) {
            int curr = propertyIds[i];
            if (curr == prev) {
                throw new IllegalArgumentException(String.format("Provided two queries for property %s. Only one query per property key can be performed", tokenRead.propertyKeyGetName(curr)));
            }
            prev = curr;
        }
    }

    private static boolean hasSamePropertyIds(int[] original, int[] workingCopy, int[] propertyIds) {
        if (original.length == propertyIds.length) {
            System.arraycopy(original, 0, workingCopy, 0, original.length);
            Arrays.sort(workingCopy);
            return Arrays.equals(propertyIds, workingCopy);
        }
        return false;
    }

    private static int[] getPropertyIds(IndexQuery[] queries) {
        int[] propertyIds = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            propertyIds[i] = queries[i].propertyKeyId();
        }
        return propertyIds;
    }

    private static boolean isInvalidQuery(int labelId, IndexQuery[] queries) {
        boolean invalidQuery = labelId == -1;
        for (IndexQuery query : queries) {
            int propertyKeyId = query.propertyKeyId();
            invalidQuery = invalidQuery || propertyKeyId == -1;
        }
        return invalidQuery;
    }

    private <T> Iterable<T> allInUse(TokenAccess<T> tokens) {
        KernelTransaction transaction = this.kernelTransaction();
        return () -> tokens.inUse(transaction);
    }

    private <T> Iterable<T> all(TokenAccess<T> tokens) {
        KernelTransaction transaction = this.kernelTransaction();
        return () -> tokens.all(transaction);
    }

    @FunctionalInterface
    private static interface TransactionalOperation {
        public void perform(KernelTransaction var1) throws Exception;
    }
}

