/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.KernelTransaction;

class EntityLocker {
    EntityLocker() {
    }

    Lock exclusiveLock(KernelTransaction ktx, Entity entity) {
        long id = entity.getId();
        if (entity instanceof Node) {
            ktx.locks().acquireExclusiveNodeLock(new long[]{id});
            return new CoreAPILock(() -> ktx.locks().releaseExclusiveNodeLock(new long[]{id}));
        }
        if (entity instanceof Relationship) {
            ktx.locks().acquireExclusiveRelationshipLock(new long[]{id});
            return new CoreAPILock(() -> ktx.locks().releaseExclusiveRelationshipLock(new long[]{id}));
        }
        throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
    }

    Lock sharedLock(KernelTransaction ktx, Entity entity) {
        long id = entity.getId();
        if (entity instanceof Node) {
            ktx.locks().acquireSharedNodeLock(new long[]{id});
            return new CoreAPILock(() -> ktx.locks().releaseSharedNodeLock(new long[]{id}));
        }
        if (entity instanceof Relationship) {
            ktx.locks().acquireSharedRelationshipLock(new long[]{id});
            return new CoreAPILock(() -> ktx.locks().releaseSharedRelationshipLock(new long[]{id}));
        }
        throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
    }

    private static class CoreAPILock
    implements Lock {
        private boolean released;
        private final Runnable release;

        CoreAPILock(Runnable release) {
            this.release = release;
        }

        public void release() {
            if (this.released) {
                throw new IllegalStateException("Already released");
            }
            this.released = true;
            this.release.run();
        }
    }
}

