/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.IOException;
import java.io.InputStream;

class ProgressAwareInputStream
extends InputStream {
    private final OnProgressListener listener;
    private final InputStream wrappedInputStream;
    private final long size;
    private long totalRead;
    private int lastReportedPercent;

    ProgressAwareInputStream(InputStream wrappedInputStream, long size, OnProgressListener listener) {
        this.wrappedInputStream = wrappedInputStream;
        this.size = size;
        this.listener = listener;
    }

    @Override
    public int read() throws IOException {
        int data = this.wrappedInputStream.read();
        if (data >= 0) {
            ++this.totalRead;
            this.recalculatePercent();
        }
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = this.wrappedInputStream.read(b);
        if (n > 0) {
            this.totalRead += (long)n;
            this.recalculatePercent();
        }
        return n;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int n = this.wrappedInputStream.read(b, offset, length);
        if (n > 0) {
            this.totalRead += (long)n;
            this.recalculatePercent();
        }
        return n;
    }

    private void recalculatePercent() {
        int percent;
        int n = percent = this.size > 0L ? (int)(this.totalRead * 100L / this.size) : -1;
        if (percent > 100) {
            percent = 100;
        }
        if (percent < 0) {
            percent = 0;
        }
        if (percent > this.lastReportedPercent) {
            this.lastReportedPercent = percent;
            this.listener.onProgress(percent);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.wrappedInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.wrappedInputStream.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    public static interface OnProgressListener {
        public void onProgress(int var1);
    }
}

