/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.kernel.database.DatabaseId;

public class NamedDatabaseId
implements Comparable<NamedDatabaseId> {
    private final String name;
    private final DatabaseId databaseId;

    NamedDatabaseId(String name, UUID uuid) {
        this(name, new DatabaseId(uuid));
    }

    NamedDatabaseId(String name, DatabaseId databaseId) {
        Objects.requireNonNull(databaseId, "DatabaseId should be not null.");
        Objects.requireNonNull(name, "Database name should be not null.");
        this.databaseId = databaseId;
        this.name = new NormalizedDatabaseName(name).name();
    }

    public String name() {
        return this.name;
    }

    public DatabaseId databaseId() {
        return this.databaseId;
    }

    public String logPrefix() {
        return this.name + "/" + this.databaseId.id();
    }

    public String toString() {
        return "DatabaseId{" + this.databaseId.id() + "[" + this.name + "]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedDatabaseId that = (NamedDatabaseId)o;
        return this.databaseId.equals(that.databaseId);
    }

    public int hashCode() {
        return Objects.hash(this.databaseId);
    }

    @Override
    public int compareTo(NamedDatabaseId that) {
        boolean leftIsSystem = this.isSystemDatabase();
        boolean rightIsSystem = that.isSystemDatabase();
        if (leftIsSystem || rightIsSystem) {
            return Boolean.compare(rightIsSystem, leftIsSystem);
        }
        return this.name.compareTo(that.name);
    }

    public boolean isSystemDatabase() {
        return this.databaseId.isSystemDatabase();
    }
}

