/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.TransactionIdStore;

class TransactionCommitment
implements Commitment {
    private final long transactionId;
    private final int transactionChecksum;
    private final long transactionCommitTimestamp;
    private final LogPosition logPosition;
    private final TransactionIdStore transactionIdStore;
    private boolean markedAsCommitted;

    TransactionCommitment(long transactionId, int transactionChecksum, long transactionCommitTimestamp, LogPosition logPosition, TransactionIdStore transactionIdStore) {
        this.transactionId = transactionId;
        this.transactionChecksum = transactionChecksum;
        this.transactionCommitTimestamp = transactionCommitTimestamp;
        this.logPosition = logPosition;
        this.transactionIdStore = transactionIdStore;
    }

    public LogPosition logPosition() {
        return this.logPosition;
    }

    @Override
    public void publishAsCommitted(PageCursorTracer cursorTracer) {
        this.markedAsCommitted = true;
        this.transactionIdStore.transactionCommitted(this.transactionId, this.transactionChecksum, this.transactionCommitTimestamp, cursorTracer);
    }

    @Override
    public void publishAsClosed(PageCursorTracer cursorTracer) {
        this.transactionIdStore.transactionClosed(this.transactionId, this.logPosition.getLogVersion(), this.logPosition.getByteOffset(), cursorTracer);
    }

    @Override
    public boolean markedAsCommitted() {
        return this.markedAsCommitted;
    }

    public int getTransactionChecksum() {
        return this.transactionChecksum;
    }
}

