/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.impl.scheduler.ScheduledJobHandle;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

final class TimeBasedTaskScheduler
implements Runnable {
    private static final long NO_TASKS_PARK = TimeUnit.MINUTES.toNanos(10L);
    private static final Comparator<ScheduledJobHandle<?>> DEADLINE_COMPARATOR = Comparator.comparingLong(handle -> handle.nextDeadlineNanos);
    private final SystemNanoClock clock;
    private final ThreadPoolManager pools;
    private final PriorityBlockingQueue<ScheduledJobHandle<?>> delayedTasks;
    private final ConcurrentLinkedQueue<ScheduledJobHandle<?>> canceledTasks;
    private volatile Thread timeKeeper;
    private volatile boolean stopped;

    TimeBasedTaskScheduler(SystemNanoClock clock, ThreadPoolManager pools) {
        this.clock = clock;
        this.pools = pools;
        this.delayedTasks = new PriorityBlockingQueue(42, DEADLINE_COMPARATOR);
        this.canceledTasks = new ConcurrentLinkedQueue();
    }

    public JobHandle<?> submit(Group group, Runnable job, long initialDelayNanos, long reschedulingDelayNanos) {
        long now = this.clock.nanos();
        long nextDeadlineNanos = now + initialDelayNanos;
        ScheduledJobHandle task = new ScheduledJobHandle(this, group, job, nextDeadlineNanos, reschedulingDelayNanos);
        this.enqueueTask(task);
        return task;
    }

    void enqueueTask(ScheduledJobHandle<?> newTasks) {
        this.delayedTasks.offer(newTasks);
        LockSupport.unpark(this.timeKeeper);
    }

    @Override
    public void run() {
        this.timeKeeper = Thread.currentThread();
        while (!this.stopped) {
            long timeToNextTickNanos = this.tick();
            if (this.stopped) {
                return;
            }
            LockSupport.parkNanos(this, timeToNextTickNanos);
        }
    }

    public long tick() {
        long now = this.clock.nanos();
        long timeToNextDeadlineSinceStart = this.scheduleDueTasks(now);
        long processingTime = this.clock.nanos() - now;
        return timeToNextDeadlineSinceStart - processingTime;
    }

    private long scheduleDueTasks(long now) {
        if (this.delayedTasks.isEmpty()) {
            return NO_TASKS_PARK;
        }
        while (!this.canceledTasks.isEmpty()) {
            ScheduledJobHandle<?> canceled = this.canceledTasks.poll();
            this.delayedTasks.remove(canceled);
        }
        while (!this.stopped && !this.delayedTasks.isEmpty() && this.delayedTasks.peek().nextDeadlineNanos <= now) {
            ScheduledJobHandle<?> task = this.delayedTasks.poll();
            task.submitIfRunnable(this.pools);
        }
        return this.delayedTasks.isEmpty() ? NO_TASKS_PARK : this.delayedTasks.peek().nextDeadlineNanos - now;
    }

    @VisibleForTesting
    int tasksLeft() {
        return this.delayedTasks.size();
    }

    public void stop() {
        this.stopped = true;
        LockSupport.unpark(this.timeKeeper);
    }

    void cancelTask(ScheduledJobHandle<?> job) {
        this.canceledTasks.add(job);
    }
}

