/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.MaximumTransactionLimitExceededException;
import org.neo4j.kernel.impl.api.TokenHoldersIdLookup;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public class KernelTransactions
extends LifecycleAdapter
implements Supplier<IdController.ConditionSnapshot> {
    private final StatementLocksFactory statementLocksFactory;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final TransactionCommitProcess transactionCommitProcess;
    private final DatabaseTransactionEventListeners eventListeners;
    private final TransactionMonitor transactionMonitor;
    private final AvailabilityGuard databaseAvailabilityGuard;
    private final StorageEngine storageEngine;
    private final GlobalProcedures globalProcedures;
    private final TransactionIdStore transactionIdStore;
    private final AtomicReference<CpuClock> cpuClockRef;
    private final AccessCapability accessCapability;
    private final SystemNanoClock clock;
    private final VersionContextSupplier versionContextSupplier;
    private final ReentrantReadWriteLock newTransactionsLock = new ReentrantReadWriteLock();
    private final MonotonicCounter userTransactionIdCounter = MonotonicCounter.newAtomicMonotonicCounter();
    private final TokenHolders tokenHolders;
    private final NamedDatabaseId namedDatabaseId;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final RelationshipTypeScanStore relationshipTypeScanStore;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Dependencies databaseDependendies;
    private final Config config;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final SchemaState schemaState;
    private final LeaseService leaseService;
    private final Set<KernelTransactionImplementation> allTransactions = ConcurrentHashMap.newKeySet();
    private final Factory<KernelTransactionImplementation> factory;
    private final LinkedQueuePool<KernelTransactionImplementation> globalTxPool;
    private final MarshlandPool<KernelTransactionImplementation> localTxPool;
    private final ConstraintSemantics constraintSemantics;
    private final AtomicInteger activeTransactionCounter = new AtomicInteger();
    private final TokenHoldersIdLookup tokenHoldersIdLookup;
    private final ScopedMemoryPool transactionMemoryPool;
    private volatile boolean stopped = true;

    public KernelTransactions(Config config, StatementLocksFactory statementLocksFactory, ConstraintIndexCreator constraintIndexCreator, TransactionCommitProcess transactionCommitProcess, DatabaseTransactionEventListeners eventListeners, TransactionMonitor transactionMonitor, AvailabilityGuard databaseAvailabilityGuard, StorageEngine storageEngine, GlobalProcedures globalProcedures, TransactionIdStore transactionIdStore, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, AccessCapability accessCapability, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState, TokenHolders tokenHolders, NamedDatabaseId namedDatabaseId, IndexingService indexingService, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, IndexStatisticsStore indexStatisticsStore, Dependencies databaseDependencies, DatabaseTracers tracers, LeaseService leaseService, GlobalMemoryGroupTracker transactionsMemoryPool) {
        this.config = config;
        this.statementLocksFactory = statementLocksFactory;
        this.constraintIndexCreator = constraintIndexCreator;
        this.transactionCommitProcess = transactionCommitProcess;
        this.eventListeners = eventListeners;
        this.transactionMonitor = transactionMonitor;
        this.databaseAvailabilityGuard = databaseAvailabilityGuard;
        this.storageEngine = storageEngine;
        this.globalProcedures = globalProcedures;
        this.transactionIdStore = transactionIdStore;
        this.cpuClockRef = cpuClockRef;
        this.accessCapability = accessCapability;
        this.tokenHolders = tokenHolders;
        this.tokenHoldersIdLookup = new TokenHoldersIdLookup(tokenHolders);
        this.namedDatabaseId = namedDatabaseId;
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.relationshipTypeScanStore = relationshipTypeScanStore;
        this.indexStatisticsStore = indexStatisticsStore;
        this.databaseDependendies = databaseDependencies;
        this.versionContextSupplier = versionContextSupplier;
        this.clock = clock;
        this.collectionsFactorySupplier = collectionsFactorySupplier;
        this.constraintSemantics = constraintSemantics;
        this.schemaState = schemaState;
        this.leaseService = leaseService;
        this.factory = new KernelTransactionImplementationFactory(this.allTransactions, tracers);
        this.globalTxPool = new GlobalKernelTransactionPool(this.allTransactions, this.factory);
        this.localTxPool = new LocalKernelTransactionPool((Pool<KernelTransactionImplementation>)this.globalTxPool, this.activeTransactionCounter, config);
        this.transactionMemoryPool = transactionsMemoryPool.newDatabasePool(namedDatabaseId.name(), ((Long)config.get(GraphDatabaseSettings.memory_transaction_database_max_size)).longValue(), GraphDatabaseSettings.memory_transaction_database_max_size.name());
        config.addListener(GraphDatabaseSettings.memory_transaction_database_max_size, (before, after) -> this.transactionMemoryPool.setSize(after.longValue()));
        this.doBlockNewTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelTransaction newInstance(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout) {
        this.assertCurrentThreadIsNotBlockingNewTransactions();
        SecurityContext securityContext = loginContext.authorize((LoginContext.IdLookup)this.tokenHoldersIdLookup, this.namedDatabaseId.name());
        while (!this.newTransactionsLock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
            this.assertRunning();
        }
        try {
            this.assertRunning();
            TransactionId lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
            KernelTransactionImplementation tx = (KernelTransactionImplementation)this.localTxPool.acquire();
            StatementLocks statementLocks = this.statementLocksFactory.newInstance();
            tx.initialize(lastCommittedTransaction.transactionId(), lastCommittedTransaction.commitTimestamp(), statementLocks, type, securityContext, timeout, this.userTransactionIdCounter.incrementAndGet(), clientInfo);
            KernelTransactionImplementation kernelTransactionImplementation = tx;
            this.newTransactionsLock.readLock().unlock();
            return kernelTransactionImplementation;
        }
        catch (Throwable throwable) {
            try {
                this.newTransactionsLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new TransactionFailureException("Fail to start new transaction.", (Throwable)ie);
            }
        }
    }

    public Set<KernelTransactionHandle> activeTransactions() {
        return this.allTransactions.stream().map(this::createHandle).filter(KernelTransactionHandle::isOpen).collect(Collectors.toSet());
    }

    public Set<KernelTransactionHandle> executingTransactions() {
        return this.allTransactions.stream().map(this::createHandle).filter(h -> h.isOpen() || h.isClosing()).collect(Collectors.toSet());
    }

    public void disposeAll() {
        this.terminateTransactions();
        this.localTxPool.close();
        this.globalTxPool.close();
    }

    public void terminateTransactions() {
        this.markAllTransactionsAsTerminated();
    }

    private void markAllTransactionsAsTerminated() {
        this.allTransactions.forEach(tx -> tx.markForTermination((Status)Status.Database.DatabaseUnavailable));
    }

    public boolean haveClosingTransaction() {
        return this.allTransactions.stream().anyMatch(KernelTransactionImplementation::isClosing);
    }

    public void start() {
        this.stopped = false;
        this.unblockNewTransactions();
    }

    public void stop() {
        this.blockNewTransactions();
        this.stopped = true;
    }

    public void shutdown() {
        this.transactionMemoryPool.close();
        this.disposeAll();
        this.unblockNewTransactions();
    }

    @Override
    public IdController.ConditionSnapshot get() {
        return new KernelTransactionsSnapshot(this.activeTransactions());
    }

    public void blockNewTransactions() {
        this.doBlockNewTransactions();
    }

    private void doBlockNewTransactions() {
        this.newTransactionsLock.writeLock().lock();
    }

    public void unblockNewTransactions() {
        if (!this.newTransactionsLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("This thread did not block transactions previously");
        }
        this.newTransactionsLock.writeLock().unlock();
    }

    public int getNumberOfActiveTransactions() {
        return this.activeTransactionCounter.get();
    }

    KernelTransactionHandle createHandle(KernelTransactionImplementation tx) {
        return new KernelTransactionImplementationHandle(tx, this.clock);
    }

    private void assertRunning() {
        if (this.databaseAvailabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException();
        }
        if (this.stopped) {
            throw new IllegalStateException("Can't start new transaction with stopped " + this.getClass());
        }
    }

    private void assertCurrentThreadIsNotBlockingNewTransactions() {
        if (this.newTransactionsLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Thread that is blocking new transactions from starting can't start new transaction");
        }
    }

    private static class LocalKernelTransactionPool
    extends MarshlandPool<KernelTransactionImplementation> {
        private final AtomicInteger activeTransactionCounter;
        private volatile int maxNumberOfTransaction;

        LocalKernelTransactionPool(Pool<KernelTransactionImplementation> delegatePool, AtomicInteger activeTransactionCounter, Config config) {
            super(delegatePool);
            this.activeTransactionCounter = activeTransactionCounter;
            this.maxNumberOfTransaction = (Integer)config.get(GraphDatabaseSettings.max_concurrent_transactions);
            config.addListener(GraphDatabaseSettings.max_concurrent_transactions, (oldValue, newValue) -> {
                this.maxNumberOfTransaction = newValue;
            });
        }

        public KernelTransactionImplementation acquire() {
            this.verifyTransactionsLimit();
            return (KernelTransactionImplementation)super.acquire();
        }

        public void release(KernelTransactionImplementation obj) {
            this.activeTransactionCounter.decrementAndGet();
            super.release((Object)obj);
        }

        private void verifyTransactionsLimit() {
            int activeTransactions;
            do {
                activeTransactions = this.activeTransactionCounter.get();
                int localTransactionMaximum = this.maxNumberOfTransaction;
                if (localTransactionMaximum == 0 || activeTransactions < localTransactionMaximum) continue;
                throw new MaximumTransactionLimitExceededException();
            } while (!this.activeTransactionCounter.weakCompareAndSetAcquire(activeTransactions, activeTransactions + 1));
        }
    }

    private static class GlobalKernelTransactionPool
    extends LinkedQueuePool<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;

        GlobalKernelTransactionPool(Set<KernelTransactionImplementation> transactions, Factory<KernelTransactionImplementation> factory) {
            super(8, factory);
            this.transactions = transactions;
        }

        protected void dispose(KernelTransactionImplementation tx) {
            this.transactions.remove(tx);
            tx.dispose();
            super.dispose((Object)tx);
        }
    }

    private class KernelTransactionImplementationFactory
    implements Factory<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;
        private final DatabaseTracers tracers;

        KernelTransactionImplementationFactory(Set<KernelTransactionImplementation> transactions, DatabaseTracers tracers) {
            this.transactions = transactions;
            this.tracers = tracers;
        }

        public KernelTransactionImplementation newInstance() {
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.config, KernelTransactions.this.eventListeners, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.globalProcedures, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, (Pool<KernelTransactionImplementation>)KernelTransactions.this.localTxPool, KernelTransactions.this.clock, KernelTransactions.this.cpuClockRef, this.tracers, KernelTransactions.this.storageEngine, KernelTransactions.this.accessCapability, KernelTransactions.this.versionContextSupplier, KernelTransactions.this.collectionsFactorySupplier, KernelTransactions.this.constraintSemantics, KernelTransactions.this.schemaState, KernelTransactions.this.tokenHolders, KernelTransactions.this.indexingService, KernelTransactions.this.labelScanStore, KernelTransactions.this.relationshipTypeScanStore, KernelTransactions.this.indexStatisticsStore, KernelTransactions.this.databaseDependendies, KernelTransactions.this.namedDatabaseId, KernelTransactions.this.leaseService, KernelTransactions.this.transactionMemoryPool);
            this.transactions.add(tx);
            return tx;
        }
    }
}

