/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

public class LogVersionUpgradeChecker {
    private LogVersionUpgradeChecker() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static void check(LogTailScanner tailScanner, boolean upgradeAllowed) throws UpgradeNotAllowedException {
        byte latestLogEntryVersion;
        if (!upgradeAllowed && (latestLogEntryVersion = tailScanner.getTailInformation().latestLogEntryVersion) != 0 && LogEntryVersion.moreRecentVersionExists((byte)latestLogEntryVersion)) {
            String message = "The version you're upgrading to is using a new transaction log format. This is a non-reversible upgrade and you wont be able to downgrade after starting";
            throw new UpgradeNotAllowedException(message);
        }
    }
}

