/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.PooledJobHandle;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.SchedulerThreadFactory;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;

final class ThreadPool {
    private final SchedulerThreadFactory threadFactory;
    private final ExecutorService executor;
    private final ConcurrentHashMap<Object, Future<?>> registry;
    private InterruptedException shutdownInterrupted;

    ThreadPool(Group group, ThreadGroup parentThreadGroup, ThreadPoolParameters parameters) {
        this.threadFactory = parameters.providedThreadFactory.newSchedulerThreadFactory(group, parentThreadGroup);
        this.executor = group.buildExecutorService(this.threadFactory, parameters.desiredParallelism);
        this.registry = new ConcurrentHashMap();
    }

    ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public <T> JobHandle<T> submit(Callable<T> job) {
        Object registryKey = new Object();
        CompletableFuture<Object> placeHolder = CompletableFuture.completedFuture(null);
        this.registry.put(registryKey, placeHolder);
        Callable<Object> registeredJob = () -> {
            try {
                Object v = job.call();
                return v;
            }
            finally {
                this.registry.remove(registryKey);
            }
        };
        Future<Object> future = this.executor.submit(registeredJob);
        this.registry.replace(registryKey, placeHolder, future);
        return new PooledJobHandle<Object>(future, registryKey, this.registry);
    }

    public JobHandle<?> submit(Runnable job) {
        return this.submit(ThreadPool.asCallable(job));
    }

    private static Callable<?> asCallable(Runnable job) {
        return () -> {
            job.run();
            return null;
        };
    }

    int activeJobCount() {
        return this.registry.size();
    }

    int activeThreadCount() {
        return this.threadFactory.getThreadGroup().activeCount();
    }

    Stream<Thread> activeThreads() {
        ThreadGroup threadGroup = this.threadFactory.getThreadGroup();
        int activeCountEstimate = threadGroup.activeCount();
        int activeCountFudge = Math.max((int)Math.sqrt(activeCountEstimate), 10);
        Thread[] snapshot = new Thread[activeCountEstimate + activeCountFudge];
        threadGroup.enumerate(snapshot);
        return Arrays.stream(snapshot).filter(Objects::nonNull);
    }

    void cancelAllJobs() {
        this.registry.values().removeIf(future -> {
            future.cancel(true);
            return true;
        });
    }

    void shutDown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.shutdownInterrupted = e;
        }
    }

    InterruptedException getShutdownException() {
        return this.shutdownInterrupted;
    }

    static class ThreadPoolParameters {
        volatile int desiredParallelism;
        volatile SchedulerThreadFactoryFactory providedThreadFactory = GroupedDaemonThreadFactory::new;

        ThreadPoolParameters() {
        }
    }
}

