/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;

class IndexProxyCreator {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStatisticsStore indexStatisticsStore;
    private final IndexProviderMap providerMap;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    IndexProxyCreator(IndexSamplingConfig samplingConfig, IndexStatisticsStore indexStatisticsStore, IndexProviderMap providerMap, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.samplingConfig = samplingConfig;
        this.indexStatisticsStore = indexStatisticsStore;
        this.providerMap = providerMap;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    IndexProxy createPopulatingIndexProxy(IndexDescriptor index, boolean flipToTentative, IndexingService.Monitor monitor, IndexPopulationJob populationJob) {
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = index.userDescription(this.tokenNameLookup);
        IndexPopulator populator = this.populatorFromProvider(index, this.samplingConfig, populationJob.bufferFactory(), populationJob.getMemoryTracker());
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(index, (MinimalIndexAccessor)populator, indexUserDescription, this.indexStatisticsStore, this.logProvider);
        MultipleIndexPopulator.IndexPopulation indexPopulation = populationJob.addPopulator(populator, index, indexUserDescription, flipper, failureDelegateFactory);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(index, populationJob, indexPopulation);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(() -> {
            monitor.populationCompleteOn(index);
            IndexAccessor accessor = this.onlineAccessorFromProvider(index, this.samplingConfig);
            OnlineIndexProxy onlineProxy = new OnlineIndexProxy(index, accessor, this.indexStatisticsStore, true);
            if (flipToTentative) {
                return new TentativeConstraintIndexProxy(flipper, onlineProxy, this.tokenNameLookup);
            }
            return onlineProxy;
        });
        return new ContractCheckingIndexProxy(flipper);
    }

    IndexProxy createRecoveringIndexProxy(IndexDescriptor descriptor) {
        RecoveringIndexProxy proxy = new RecoveringIndexProxy(descriptor);
        return new ContractCheckingIndexProxy(proxy);
    }

    IndexProxy createOnlineIndexProxy(IndexDescriptor descriptor) {
        try {
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(descriptor, this.samplingConfig);
            IndexProxy proxy = new OnlineIndexProxy(descriptor, onlineAccessor, this.indexStatisticsStore, false);
            proxy = new ContractCheckingIndexProxy(proxy);
            return proxy;
        }
        catch (IOException e) {
            this.logProvider.getLog(this.getClass()).error("Failed to open index: " + descriptor.getId() + " (" + descriptor.userDescription(this.tokenNameLookup) + "), requesting re-population.", (Throwable)e);
            return this.createRecoveringIndexProxy(descriptor);
        }
    }

    IndexProxy createFailedIndexProxy(IndexDescriptor descriptor, IndexPopulationFailure populationFailure) {
        MinimalIndexAccessor minimalIndexAccessor = this.minimalIndexAccessorFromProvider(descriptor);
        String indexUserDescription = descriptor.userDescription(this.tokenNameLookup);
        IndexProxy proxy = new FailedIndexProxy(descriptor, indexUserDescription, minimalIndexAccessor, populationFailure, this.indexStatisticsStore, this.logProvider);
        proxy = new ContractCheckingIndexProxy(proxy);
        return proxy;
    }

    private IndexPopulator populatorFromProvider(IndexDescriptor index, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker) {
        IndexProvider provider = this.providerMap.lookup(index.getIndexProvider());
        return provider.getPopulator(index, samplingConfig, bufferFactory, memoryTracker);
    }

    private MinimalIndexAccessor minimalIndexAccessorFromProvider(IndexDescriptor index) {
        IndexProvider provider = this.providerMap.lookup(index.getIndexProvider());
        return provider.getMinimalIndexAccessor(index);
    }

    private IndexAccessor onlineAccessorFromProvider(IndexDescriptor index, IndexSamplingConfig samplingConfig) throws IOException {
        IndexProvider provider = this.providerMap.lookup(index.getIndexProvider());
        return provider.getOnlineAccessor(index, samplingConfig);
    }
}

