/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.runners.model.Statement;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.test.rule.CleanupRule;

class TestCleanupRule {
    TestCleanupRule() {
    }

    @Test
    void shouldCleanupAutoCloseable() throws Throwable {
        CleanupRule rule = new CleanupRule();
        AutoCloseable toClose = rule.add((AutoCloseable)Mockito.mock(AutoCloseable.class));
        TestCleanupRule.simulateTestExecution(rule);
        ((AutoCloseable)Mockito.verify((Object)toClose)).close();
    }

    @Test
    void shouldCleanupObjectWithAppropriateCloseMethod() throws Throwable {
        CleanupRule rule = new CleanupRule();
        Dirt toClose = (Dirt)rule.add((Object)((Dirt)Mockito.mock(Dirt.class)));
        TestCleanupRule.simulateTestExecution(rule);
        ((Dirt)Mockito.verify((Object)toClose)).shutdown();
    }

    @Test
    void shouldCleanupMultipleObjectsInReverseAddedOrder() throws Throwable {
        CleanupRule rule = new CleanupRule();
        AutoCloseable closeable = rule.add((AutoCloseable)Mockito.mock(AutoCloseable.class));
        Dirt dirt = (Dirt)rule.add((Object)((Dirt)Mockito.mock(Dirt.class)));
        TestCleanupRule.simulateTestExecution(rule);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dirt, closeable});
        ((Dirt)inOrder.verify((Object)dirt)).shutdown();
        ((AutoCloseable)inOrder.verify((Object)closeable)).close();
    }

    @Test
    void shouldTellUserIllegalArgumentIfSo() {
        CleanupRule rule = new CleanupRule();
        Assertions.assertThrows(IllegalArgumentException.class, () -> rule.add(new Object()));
    }

    private static void simulateTestExecution(CleanupRule rule) throws Throwable {
        rule.apply(new Statement(){

            public void evaluate() {
            }
        }, null).evaluate();
    }

    private static interface Dirt {
        public void shutdown();
    }
}

