/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.storageengine.api.StoreId;

class RecoveryStartInformationProviderTest {
    private final long currentLogVersion = 2L;
    private final long logVersion = 2L;
    private final LogTailScanner tailScanner = (LogTailScanner)Mockito.mock(LogTailScanner.class);
    private final LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
    private final RecoveryStartInformationProvider.Monitor monitor = (RecoveryStartInformationProvider.Monitor)Mockito.mock(RecoveryStartInformationProvider.Monitor.class);

    RecoveryStartInformationProviderTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        LogHeader logHeader = new LogHeader(0L, 1L, StoreId.UNKNOWN);
        Mockito.when((Object)this.logFiles.extractHeader(0L)).thenReturn((Object)logHeader);
    }

    @Test
    void shouldReturnUnspecifiedIfThereIsNoNeedForRecovery() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(false, -1L, 2L, 2L, LogEntryVersion.LATEST.version()));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.logFiles, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).noCommitsAfterLastCheckPoint(null);
        Assertions.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)recoveryStartInformation.getRecoveryPosition());
        Assertions.assertEquals((long)-1L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assertions.assertFalse((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    void shouldReturnLogPositionToRecoverFromIfNeeded() {
        LogPosition checkPointLogPosition = new LogPosition(1L, 4242L);
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(new CheckPoint(checkPointLogPosition), true, 10L, 2L, 2L, LogEntryVersion.LATEST.version(), StoreId.UNKNOWN));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.logFiles, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).commitsAfterLastCheckPoint(checkPointLogPosition, 10L);
        Assertions.assertEquals((Object)checkPointLogPosition, (Object)recoveryStartInformation.getRecoveryPosition());
        Assertions.assertEquals((long)10L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assertions.assertTrue((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    void shouldRecoverFromStartOfLogZeroIfThereAreNoCheckPointAndOldestLogIsVersionZero() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(true, 10L, 0L, 2L, LogEntryVersion.LATEST.version()));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.logFiles, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).noCheckPointFound();
        Assertions.assertEquals((Object)new LogPosition(0L, 64L), (Object)recoveryStartInformation.getRecoveryPosition());
        Assertions.assertEquals((long)10L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assertions.assertTrue((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    void detectMissingTransactionLogsInformation() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(false, -1L, -1L, -1L, LogEntryVersion.LATEST.version()));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.logFiles, this.monitor).get();
        Assertions.assertSame((Object)RecoveryStartInformation.MISSING_LOGS, (Object)recoveryStartInformation);
    }

    @Test
    void shouldFailIfThereAreNoCheckPointsAndOldestLogVersionInNotZero() {
        long oldestLogVersionFound = 1L;
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(true, 10L, oldestLogVersionFound, 2L, LogEntryVersion.LATEST.version()));
        UnderlyingStorageException storageException = (UnderlyingStorageException)Assertions.assertThrows(UnderlyingStorageException.class, () -> new RecoveryStartInformationProvider(this.tailScanner, this.logFiles, this.monitor).get());
        String expectedMessage = "No check point found in any log file from version " + oldestLogVersionFound + " to 2";
        Assertions.assertEquals((Object)expectedMessage, (Object)storageException.getMessage());
    }
}

