/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.kernel.internal.locker.GlobalLocker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class GlobalStoreLockerTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;

    GlobalStoreLockerTest() {
    }

    @Test
    void failToLockSameFolderAcrossIndependentLockers() throws Exception {
        try (GlobalLocker storeLocker = new GlobalLocker(this.fileSystem, this.neo4jLayout);){
            storeLocker.checkLock();
            Assertions.assertThrows(FileLockException.class, () -> {
                try (GlobalLocker locker = new GlobalLocker(this.fileSystem, this.neo4jLayout);){
                    locker.checkLock();
                }
            });
            Assertions.assertThrows(FileLockException.class, () -> {
                try (GlobalLocker locker = new GlobalLocker(this.fileSystem, this.neo4jLayout);){
                    locker.checkLock();
                }
            });
        }
    }

    @Test
    void allowToLockSameDirectoryIfItWasUnlocked() throws IOException {
        try (GlobalLocker storeLocker = new GlobalLocker(this.fileSystem, this.neo4jLayout);){
            storeLocker.checkLock();
        }
        storeLocker = new GlobalLocker(this.fileSystem, this.neo4jLayout);
        try {
            storeLocker.checkLock();
        }
        finally {
            storeLocker.close();
        }
    }

    @Test
    void allowMultipleCallstoActuallyStoreLocker() throws IOException {
        try (GlobalLocker storeLocker = new GlobalLocker(this.fileSystem, this.neo4jLayout);){
            storeLocker.checkLock();
            storeLocker.checkLock();
            storeLocker.checkLock();
            storeLocker.checkLock();
            storeLocker.checkLock();
        }
    }
}

