/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.info.CannedJvmMetadataRepository;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;

class JVMCheckerTest {
    JVMCheckerTest() {
    }

    @Test
    void shouldIssueWarningWhenUsingHotspotServerVmVersion12() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "12")).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).contains(new CharSequence[]{"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."});
    }

    @Test
    void shouldNotIssueWarningWhenUsingHotspotServerVmVersion11() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11")).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).doesNotContain(new CharSequence[]{"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."});
    }

    @Test
    void shouldIssueWarningWhenUsingUnsupportedJvmVersion() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "22.33.44.55")).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).contains(new CharSequence[]{"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11."});
    }

    @Test
    void warnAboutMissingInitialHeapSize() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.2+9", Collections.singletonList("-XMx"), 12L, 23L)).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).contains(new CharSequence[]{JvmChecker.memorySettingWarning((Setting)ExternalSettings.initial_heap_size, (long)12L)});
    }

    @Test
    void warnAboutMissingMaximumHeapSize() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11", Collections.singletonList("-XMs"), 12L, 23L)).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).contains(new CharSequence[]{JvmChecker.memorySettingWarning((Setting)ExternalSettings.max_heap_size, (long)23L)});
    }

    @Test
    void warnAboutMissingHeapSizes() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.1")).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).contains(new CharSequence[]{JvmChecker.memorySettingWarning((Setting)ExternalSettings.initial_heap_size, (long)1L)});
        Assertions.assertThat((String)bufferingLogger.toString()).contains(new CharSequence[]{JvmChecker.memorySettingWarning((Setting)ExternalSettings.max_heap_size, (long)2L)});
    }

    @Test
    void doNotWarnAboutMissingHeapSizesWhenOptionsSpecified() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "11.0.2", Arrays.asList("-xMx", "-xmS"), 1L, 2L)).checkJvmCompatibilityAndIssueWarning();
        Assertions.assertThat((String)bufferingLogger.toString()).doesNotContain(new CharSequence[]{JvmChecker.memorySettingWarning((Setting)ExternalSettings.initial_heap_size, (long)1L)});
        Assertions.assertThat((String)bufferingLogger.toString()).doesNotContain(new CharSequence[]{JvmChecker.memorySettingWarning((Setting)ExternalSettings.max_heap_size, (long)2L)});
    }
}

