/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureArgumentFormatter;

class DbStructureArgumentFormatterTest {
    DbStructureArgumentFormatterTest() {
    }

    @Test
    void shouldFormatNull() {
        Assertions.assertEquals((Object)"null", (Object)DbStructureArgumentFormatterTest.formatArgument(null));
    }

    @Test
    void shouldFormatInts() {
        Assertions.assertEquals((Object)"0", (Object)DbStructureArgumentFormatterTest.formatArgument(0));
        Assertions.assertEquals((Object)"1", (Object)DbStructureArgumentFormatterTest.formatArgument(1));
        Assertions.assertEquals((Object)"-1", (Object)DbStructureArgumentFormatterTest.formatArgument(-1));
    }

    @Test
    void shouldFormatLongs() {
        Assertions.assertEquals((Object)"0L", (Object)DbStructureArgumentFormatterTest.formatArgument(0L));
        Assertions.assertEquals((Object)"-1L", (Object)DbStructureArgumentFormatterTest.formatArgument(-1L));
        Assertions.assertEquals((Object)"1L", (Object)DbStructureArgumentFormatterTest.formatArgument(1L));
    }

    @Test
    void shouldFormatDoubles() {
        Assertions.assertEquals((Object)"1.0d", (Object)DbStructureArgumentFormatterTest.formatArgument(1.0));
        Assertions.assertEquals((Object)"Double.NaN", (Object)DbStructureArgumentFormatterTest.formatArgument(Double.NaN));
        Assertions.assertEquals((Object)"Double.POSITIVE_INFINITY", (Object)DbStructureArgumentFormatterTest.formatArgument(Double.POSITIVE_INFINITY));
        Assertions.assertEquals((Object)"Double.NEGATIVE_INFINITY", (Object)DbStructureArgumentFormatterTest.formatArgument(Double.NEGATIVE_INFINITY));
    }

    @Test
    void shouldFormatIndexDescriptors() {
        IndexDescriptor index = TestIndexDescriptorFactory.forLabel(23, 42);
        Assertions.assertEquals((Object)("IndexPrototype.forSchema( SchemaDescriptor.forLabel( 23, 42 ) ).withName( \"" + index.getName() + "\" ).materialise( " + index.getId() + " )"), (Object)DbStructureArgumentFormatterTest.formatArgument(index));
        index = TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{23}, (int[])new int[]{42}));
        Assertions.assertEquals((Object)("IndexPrototype.forSchema( SchemaDescriptor.fulltext( EntityType.NODE, IndexConfig.empty(), new int[] {23}, new int[] {42} ) ).withName( \"" + index.getName() + "\" ).materialise( " + index.getId() + " )"), (Object)DbStructureArgumentFormatterTest.formatArgument(index));
        index = TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)23, (int[])new int[]{42}));
        Assertions.assertEquals((Object)("IndexPrototype.forSchema( SchemaDescriptor.forRelType( 23, 42 ) ).withName( \"" + index.getName() + "\" ).materialise( " + index.getId() + " )"), (Object)DbStructureArgumentFormatterTest.formatArgument(index));
    }

    @Test
    void shouldFormatUniquenessConstraints() {
        Assertions.assertEquals((Object)"ConstraintDescriptorFactory.uniqueForLabel( 23, 42 )", (Object)DbStructureArgumentFormatterTest.formatArgument(ConstraintDescriptorFactory.uniqueForLabel((int)23, (int[])new int[]{42})));
    }

    @Test
    void shouldFormatCompositeUniquenessConstraints() {
        Assertions.assertEquals((Object)"ConstraintDescriptorFactory.uniqueForLabel( 23, 42, 43 )", (Object)DbStructureArgumentFormatterTest.formatArgument(ConstraintDescriptorFactory.uniqueForLabel((int)23, (int[])new int[]{42, 43})));
    }

    @Test
    void shouldFormatNodeKeyConstraints() {
        Assertions.assertEquals((Object)"ConstraintDescriptorFactory.nodeKeyForLabel( 23, 42, 43 )", (Object)DbStructureArgumentFormatterTest.formatArgument(ConstraintDescriptorFactory.nodeKeyForLabel((int)23, (int[])new int[]{42, 43})));
    }

    private static String formatArgument(Object arg) {
        StringBuilder builder = new StringBuilder();
        try {
            DbStructureArgumentFormatter.INSTANCE.formatArgument((Appendable)builder, arg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }
}

