/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class LogFileChannelNativeAccessorTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    private LogFileChannelNativeAccessor channelNativeAccessor;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private StoreChannel testStoreChannel;
    private NativeAccess nativeAccess;

    LogFileChannelNativeAccessorTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        TransactionLogFilesContext filesContext = (TransactionLogFilesContext)Mockito.mock(TransactionLogFilesContext.class);
        this.nativeAccess = (NativeAccess)Mockito.mock(NativeAccess.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)filesContext.getNativeAccess()).thenReturn((Object)this.nativeAccess);
        Mockito.when((Object)filesContext.getLogProvider()).thenReturn((Object)this.logProvider);
        Mockito.when((Object)filesContext.getRotationThreshold()).thenReturn((Object)new AtomicLong(5L));
        this.channelNativeAccessor = new LogFileChannelNativeAccessor(this.fileSystem, filesContext);
        File originalFile = this.testDirectory.file("test", new String[0]);
        this.testStoreChannel = this.fileSystem.write(originalFile);
    }

    @AfterEach
    void tearDown() throws IOException {
        if (this.testStoreChannel != null) {
            this.testStoreChannel.close();
        }
    }

    @Test
    void adviseSequentialAccess() {
        this.channelNativeAccessor.adviseSequentialAccessAndKeepInCache(this.testStoreChannel, 0L);
        ((NativeAccess)Mockito.verify((Object)this.nativeAccess)).tryAdviseSequentialAccess(ArgumentMatchers.anyInt());
    }

    @Test
    void doNotAdviseSequentialAccessOfClosedChannel() throws IOException {
        this.testStoreChannel.close();
        this.channelNativeAccessor.adviseSequentialAccessAndKeepInCache(this.testStoreChannel, 0L);
        ((NativeAccess)Mockito.verify((Object)this.nativeAccess, (VerificationMode)Mockito.never())).tryAdviseSequentialAccess(ArgumentMatchers.anyInt());
    }

    @Test
    void evictOpenChannel() {
        this.channelNativeAccessor.evictFromSystemCache(this.testStoreChannel, 0L);
        ((NativeAccess)Mockito.verify((Object)this.nativeAccess)).tryEvictFromCache(ArgumentMatchers.anyInt());
    }

    @Test
    void doNotEvictClosedChannel() throws IOException {
        this.testStoreChannel.close();
        Mockito.reset((Object[])new NativeAccess[]{this.nativeAccess});
        this.channelNativeAccessor.evictFromSystemCache(this.testStoreChannel, 0L);
        ((NativeAccess)Mockito.verify((Object)this.nativeAccess, (VerificationMode)Mockito.never())).tryEvictFromCache(ArgumentMatchers.anyInt());
    }

    @Test
    void preallocateChannel() {
        this.channelNativeAccessor.preallocateSpace(this.testStoreChannel, 3L);
        ((NativeAccess)Mockito.verify((Object)this.nativeAccess)).tryPreallocateSpace(ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
    }
}

