/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class CheckPointThresholdTestSupport {
    protected Config config;
    protected FakeClock clock;
    protected LogPruning logPruning;
    protected LogProvider logProvider;
    protected Integer intervalTx;
    protected Duration intervalTime;
    protected Consumer<String> notTriggered;
    protected BlockingQueue<String> triggerConsumer;
    protected Consumer<String> triggered;

    @BeforeEach
    public void setUp() {
        this.config = Config.defaults();
        this.clock = Clocks.fakeClock();
        this.logPruning = LogPruning.NO_PRUNING;
        this.logProvider = NullLogProvider.getInstance();
        this.intervalTx = (Integer)this.config.get(GraphDatabaseSettings.check_point_interval_tx);
        this.intervalTime = (Duration)this.config.get(GraphDatabaseSettings.check_point_interval_time);
        this.triggerConsumer = new LinkedBlockingQueue<String>();
        this.triggered = this.triggerConsumer::offer;
        this.notTriggered = s -> org.junit.jupiter.api.Assertions.fail((String)("Should not have triggered: " + s));
    }

    protected void withPolicy(String policy) {
        this.config.set(GraphDatabaseSettings.check_point_policy, (Object)((GraphDatabaseSettings.CheckpointPolicy)((SettingImpl)GraphDatabaseSettings.check_point_policy).parse(policy)));
    }

    protected void withIntervalTime(String time) {
        this.config.set(GraphDatabaseSettings.check_point_interval_time, (Object)((Duration)((SettingImpl)GraphDatabaseSettings.check_point_interval_time).parse(time)));
    }

    protected void withIntervalTx(int count) {
        this.config.set(GraphDatabaseSettings.check_point_interval_tx, (Object)count);
    }

    protected CheckPointThreshold createThreshold() {
        return CheckPointThreshold.createThreshold((Config)this.config, (SystemNanoClock)this.clock, (LogPruning)this.logPruning, (LogProvider)this.logProvider);
    }

    protected void verifyTriggered(String ... reason) {
        Assertions.assertThat((String)((String)this.triggerConsumer.poll())).contains((CharSequence[])reason);
    }

    protected void verifyNoMoreTriggers() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.triggerConsumer.isEmpty());
    }
}

