/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogFileTest {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    private final long rotationThreshold = ByteUnit.mebiBytes((long)1L);
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(2L, 0, 0L, 0L, 0L);

    TransactionLogFileTest() {
    }

    @Test
    void skipLogFileWithoutHeader() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        this.logVersionRepository.incrementAndGetVersion(PageCursorTracer.NULL);
        this.fileSystem.write(logFiles.getLogFileForVersion(this.logVersionRepository.getCurrentLogVersion())).close();
        this.transactionIdStore.transactionCommitted(5L, 5, 5L, PageCursorTracer.NULL);
        PhysicalLogicalTransactionStore.LogVersionLocator versionLocator = new PhysicalLogicalTransactionStore.LogVersionLocator(4L);
        logFiles.accept((LogHeaderVisitor)versionLocator);
        LogPosition logPosition = versionLocator.getLogPosition();
        Assertions.assertEquals((long)1L, (long)logPosition.getLogVersion());
    }

    @Test
    void preAllocateOnStartAndEvictOnShutdownNewLogFile() throws IOException {
        CapturingNativeAccess capturingNativeAccess = new CapturingNativeAccess();
        LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).withNativeAccess((NativeAccess)capturingNativeAccess).build();
        this.startStop(capturingNativeAccess, this.life);
        Assertions.assertEquals((int)1, (int)capturingNativeAccess.getPreallocateCounter());
        Assertions.assertEquals((int)1, (int)capturingNativeAccess.getEvictionCounter());
        Assertions.assertEquals((int)0, (int)capturingNativeAccess.getAdviseCounter());
        Assertions.assertEquals((int)0, (int)capturingNativeAccess.getKeepCounter());
    }

    @Test
    void adviseOnStartAndEvictOnShutdownExistingLogFile() throws IOException {
        CapturingNativeAccess capturingNativeAccess = new CapturingNativeAccess();
        this.startStop(capturingNativeAccess, this.life);
        capturingNativeAccess.reset();
        this.startStop(capturingNativeAccess, new LifeSupport());
        Assertions.assertEquals((int)0, (int)capturingNativeAccess.getPreallocateCounter());
        Assertions.assertEquals((int)1, (int)capturingNativeAccess.getEvictionCounter());
        Assertions.assertEquals((int)1, (int)capturingNativeAccess.getAdviseCounter());
        Assertions.assertEquals((int)1, (int)capturingNativeAccess.getKeepCounter());
    }

    @Test
    void shouldOpenInFreshDirectoryAndFinallyAddHeader() throws Exception {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        this.life.shutdown();
        File file = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fileSystem).withLogEntryReader(TestLogEntryReader.logEntryReader()).build().getLogFileForVersion(1L);
        LogHeader header = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (File)file, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertEquals((long)1L, (long)header.getLogVersion());
        Assertions.assertEquals((long)2L, (long)header.getLastCommittedTxId());
    }

    @Test
    void shouldWriteSomeDataIntoTheLog() throws Exception {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        FlushablePositionAwareChecksumChannel writer = logFiles.getLogFile().getWriter();
        LogPositionMarker positionMarker = new LogPositionMarker();
        writer.getCurrentPosition(positionMarker);
        int intValue = 45;
        long longValue = 4854587L;
        writer.putInt(intValue);
        writer.putLong(longValue);
        writer.prepareForFlush().flush();
        try (ReadableLogChannel reader = logFiles.getLogFile().getReader(positionMarker.newPosition());){
            Assertions.assertEquals((int)intValue, (int)reader.getInt());
            Assertions.assertEquals((long)longValue, (long)reader.getLong());
        }
    }

    @Test
    void shouldReadOlderLogs() throws Exception {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChecksumChannel writer = logFile.getWriter();
        LogPositionMarker positionMarker = new LogPositionMarker();
        writer.getCurrentPosition(positionMarker);
        LogPosition position1 = positionMarker.newPosition();
        int intValue = 45;
        long longValue = 4854587L;
        byte[] someBytes = TransactionLogFileTest.someBytes(40);
        writer.putInt(intValue);
        writer.putLong(longValue);
        writer.put(someBytes, someBytes.length);
        writer.prepareForFlush().flush();
        writer.getCurrentPosition(positionMarker);
        LogPosition position2 = positionMarker.newPosition();
        long longValue2 = 123456789L;
        writer.putLong(longValue2);
        writer.put(someBytes, someBytes.length);
        writer.prepareForFlush().flush();
        try (ReadableLogChannel reader = logFile.getReader(position1);){
            Assertions.assertEquals((int)intValue, (int)reader.getInt());
            Assertions.assertEquals((long)longValue, (long)reader.getLong());
            Assertions.assertArrayEquals((byte[])someBytes, (byte[])TransactionLogFileTest.readBytes((ReadableChannel)reader, 40));
        }
        reader = logFile.getReader(position2);
        try {
            Assertions.assertEquals((long)longValue2, (long)reader.getLong());
            Assertions.assertArrayEquals((byte[])someBytes, (byte[])TransactionLogFileTest.readBytes((ReadableChannel)reader, 40));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    void shouldVisitLogFile() throws Exception {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChecksumChannel writer = logFile.getWriter();
        LogPositionMarker mark = new LogPositionMarker();
        writer.getCurrentPosition(mark);
        for (int i = 0; i < 5; ++i) {
            writer.put((byte)i);
        }
        writer.prepareForFlush();
        AtomicBoolean called = new AtomicBoolean();
        logFile.accept(channel -> {
            for (int i = 0; i < 5; ++i) {
                Assertions.assertEquals((byte)((byte)i), (byte)channel.get());
            }
            called.set(true);
            return true;
        }, mark.newPosition());
        Assertions.assertTrue((boolean)called.get());
    }

    @Test
    void shouldCloseChannelInFailedAttemptToReadHeaderAfterOpen() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).build();
        int logVersion = 0;
        File logFile = logFiles.getLogFileForVersion((long)logVersion);
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)channel.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)32);
        Mockito.when((Object)fs.fileExists(logFile)).thenReturn((Object)true);
        Mockito.when((Object)fs.read((File)ArgumentMatchers.eq((Object)logFile))).thenReturn((Object)channel);
        Assertions.assertThrows(IncompleteLogHeaderException.class, () -> logFiles.openForVersion((long)logVersion));
        ((StoreChannel)Mockito.verify((Object)channel)).close();
    }

    @Test
    void shouldSuppressFailureToCloseChannelInFailedAttemptToReadHeaderAfterOpen() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fs).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).build();
        int logVersion = 0;
        File logFile = logFiles.getLogFileForVersion((long)logVersion);
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)channel.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)32);
        Mockito.when((Object)fs.fileExists(logFile)).thenReturn((Object)true);
        Mockito.when((Object)fs.read((File)ArgumentMatchers.eq((Object)logFile))).thenReturn((Object)channel);
        ((StoreChannel)Mockito.doThrow(IOException.class).when((Object)channel)).close();
        IncompleteLogHeaderException exception = (IncompleteLogHeaderException)Assertions.assertThrows(IncompleteLogHeaderException.class, () -> logFiles.openForVersion((long)logVersion));
        ((StoreChannel)Mockito.verify((Object)channel)).close();
        Assertions.assertEquals((int)1, (int)exception.getSuppressed().length);
        Assertions.assertTrue((boolean)(exception.getSuppressed()[0] instanceof IOException));
    }

    @Test
    void closeChannelThrowExceptionOnAttemptToAppendTransactionLogRecords() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withRotationThreshold(this.rotationThreshold).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.start();
        this.life.add((Lifecycle)logFiles);
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChecksumChannel writer = logFile.getWriter();
        this.life.shutdown();
        Assertions.assertThrows(Throwable.class, () -> writer.put((byte)7));
        Assertions.assertThrows(Throwable.class, () -> writer.putInt(7));
        Assertions.assertThrows(Throwable.class, () -> writer.putLong(7L));
        Assertions.assertThrows(Throwable.class, () -> writer.putDouble(7.0));
        Assertions.assertThrows(Throwable.class, () -> writer.putFloat(7.0f));
        Assertions.assertThrows(Throwable.class, () -> writer.putShort((short)7));
        Assertions.assertThrows(Throwable.class, () -> writer.put(new byte[]{1, 2, 3}, 3));
        Assertions.assertThrows(IllegalStateException.class, () -> writer.prepareForFlush().flush());
    }

    private static byte[] readBytes(ReadableChannel reader, int length) throws IOException {
        byte[] result = new byte[length];
        reader.get(result, length);
        return result;
    }

    private static byte[] someBytes(int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(i % 5);
        }
        return result;
    }

    private void startStop(CapturingNativeAccess capturingNativeAccess, LifeSupport lifeSupport) throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).withNativeAccess((NativeAccess)capturingNativeAccess).build();
        lifeSupport.add((Lifecycle)logFiles);
        lifeSupport.start();
        lifeSupport.shutdown();
    }

    private static class CapturingNativeAccess
    implements NativeAccess {
        private int evictionCounter;
        private int adviseCounter;
        private int preallocateCounter;
        private int keepCounter;

        private CapturingNativeAccess() {
        }

        public boolean isAvailable() {
            return true;
        }

        public NativeCallResult tryEvictFromCache(int fd) {
            ++this.evictionCounter;
            return NativeCallResult.SUCCESS;
        }

        public NativeCallResult tryAdviseSequentialAccess(int fd) {
            ++this.adviseCounter;
            return NativeCallResult.SUCCESS;
        }

        public NativeCallResult tryAdviseToKeepInCache(int fd) {
            ++this.keepCounter;
            return NativeCallResult.SUCCESS;
        }

        public NativeCallResult tryPreallocateSpace(int fd, long bytes) {
            ++this.preallocateCounter;
            return NativeCallResult.SUCCESS;
        }

        public String describe() {
            return "Test only";
        }

        public int getEvictionCounter() {
            return this.evictionCounter;
        }

        public int getAdviseCounter() {
            return this.adviseCounter;
        }

        public int getKeepCounter() {
            return this.keepCounter;
        }

        public int getPreallocateCounter() {
            return this.preallocateCounter;
        }

        public void reset() {
            this.adviseCounter = 0;
            this.evictionCounter = 0;
            this.preallocateCounter = 0;
            this.keepCounter = 0;
        }
    }
}

