/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.DatabasePanicEventGenerator;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogAppendAndRotateIT {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private DatabaseLayout databaseLayout;

    TransactionLogAppendAndRotateIT() {
    }

    @Test
    void shouldKeepTransactionsIntactWhenConcurrentlyRotationAndAppending() throws Throwable {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)logVersionRepository).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        AtomicBoolean end = new AtomicBoolean();
        AllTheMonitoring monitoring = new AllTheMonitoring(end, 100);
        SimpleTransactionIdStore txIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache metadataCache = new TransactionMetadataCache();
        monitoring.setLogFile(logFiles.getLogFile());
        DatabaseHealth health = new DatabaseHealth((PanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance());
        LogRotationImpl rotation = new LogRotationImpl(logFiles, Clock.systemUTC(), (Health)health, (LogRotationMonitor)monitoring);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFiles, (LogRotation)rotation, metadataCache, (TransactionIdStore)txIdStore, (Health)health));
        Race race = new Race();
        for (int i = 0; i < 4; ++i) {
            race.addContestant(() -> {
                while (!end.get()) {
                    try {
                        appender.append(new TransactionToApply(this.sillyTransaction(1000), PageCursorTracer.NULL), LogAppendEvent.NULL);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        end.set(true);
                        Assertions.fail((String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        race.addContestant(this.endAfterMax(250, TimeUnit.MILLISECONDS, end, monitoring));
        race.go();
        Assertions.assertTrue((monitoring.numberOfRotations() > 0 ? 1 : 0) != 0);
    }

    private Runnable endAfterMax(int time, TimeUnit unit, AtomicBoolean end, AllTheMonitoring monitoring) {
        return () -> {
            while (monitoring.numberOfRotations() < 2 && !end.get()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
            }
            long endTime = System.currentTimeMillis() + unit.toMillis(time);
            while (System.currentTimeMillis() < endTime && !end.get()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
            }
            end.set(true);
        };
    }

    private static void assertWholeTransactionsIn(LogFile logFile, long logVersion) throws IOException {
        try (ReadableLogChannel reader = logFile.getReader(new LogPosition(logVersion, 64L));){
            LogEntry entry;
            LogEntryReader entryReader = TestLogEntryReader.logEntryReader();
            boolean inTx = false;
            int transactions = 0;
            while ((entry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader)) != null) {
                if (!inTx) {
                    Assertions.assertTrue((boolean)(entry instanceof LogEntryStart));
                    inTx = true;
                    continue;
                }
                Assertions.assertTrue((entry instanceof LogEntryCommand || entry instanceof LogEntryCommit ? 1 : 0) != 0);
                if (!(entry instanceof LogEntryCommit)) continue;
                inTx = false;
                ++transactions;
            }
            Assertions.assertFalse((boolean)inTx);
            Assertions.assertTrue((transactions > 0 ? 1 : 0) != 0);
        }
    }

    private TransactionRepresentation sillyTransaction(int size) {
        ArrayList<TestCommand> commands = new ArrayList<TestCommand>(size);
        for (int i = 0; i < size; ++i) {
            commands.add(new TestCommand(30));
            commands.add(new TestCommand(60));
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0L, 0L, 0L, 0);
        return tx;
    }

    private static class AllTheMonitoring
    extends LogRotationMonitorAdapter {
        private final AtomicBoolean end;
        private final int maxNumberOfRotations;
        private final AtomicInteger rotations = new AtomicInteger();
        private volatile LogFile logFile;

        AllTheMonitoring(AtomicBoolean end, int maxNumberOfRotations) {
            this.end = end;
            this.maxNumberOfRotations = maxNumberOfRotations;
        }

        void setLogFile(LogFile logFile) {
            this.logFile = logFile;
        }

        public void finishLogRotation(File logFile, long logVersion, long lastTransactionId, long rotationMillis, long millisSinceLastRotation) {
            try {
                TransactionLogAppendAndRotateIT.assertWholeTransactionsIn(this.logFile, logVersion);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.rotations.getAndIncrement() > this.maxNumberOfRotations) {
                    this.end.set(true);
                }
            }
        }

        int numberOfRotations() {
            return this.rotations.get();
        }
    }
}

