/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

class LogVersionUpgradeCheckerTest {
    private final LogTailScanner tailScanner = (LogTailScanner)Mockito.mock(LogTailScanner.class);

    LogVersionUpgradeCheckerTest() {
    }

    @Test
    void noThrowWhenLatestVersionAndUpgradeIsNotAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.LATEST.version()));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (boolean)false);
    }

    @Test
    void throwWhenVersionIsOlderAndUpgradeIsNotAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryParserSetV2_3.V2_3.version()));
        Assertions.assertThrows(UpgradeNotAllowedException.class, () -> LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (boolean)false));
    }

    @Test
    void stillAcceptLatestVersionWhenUpgradeIsAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.LATEST.version()));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (boolean)true);
    }

    @Test
    void acceptOlderLogsWhenUpgradeIsAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryParserSetV2_3.V2_3.version()));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (boolean)true);
    }

    private static class OnlyVersionTailInformation
    extends LogTailScanner.LogTailInformation {
        OnlyVersionTailInformation(byte logEntryVersion) {
            super(false, 0L, 0L, 0L, logEntryVersion);
        }
    }
}

