/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.neo4j.common.ProgressReporter;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssert;
import org.neo4j.logging.LogAssertions;
import org.neo4j.time.FakeClock;

class VisibleMigrationProgressMonitorTest {
    VisibleMigrationProgressMonitorTest() {
    }

    @Test
    void shouldReportAllPercentageSteps() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.started(1);
        this.monitorSection(monitor, "First", 100, 40, 25, 23, 10, 50);
        monitor.completed();
        this.verifySectionReportedCorrectly(logProvider);
    }

    @Test
    void progressNeverReportMoreThenHundredPercent() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.started(1);
        this.monitorSection(monitor, "First", 100, 1, 10, 99, 170);
        monitor.completed();
        this.verifySectionReportedCorrectly(logProvider);
    }

    @Test
    void reportStartStopOfTransactionLogsMigration() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log);
        monitor.startTransactionLogsMigration();
        monitor.completeTransactionLogsMigration();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Starting transaction logs migration.", "Transaction logs migration completed."});
    }

    @Test
    void shouldIncludeDurationInCompletionMessage() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        FakeClock clock = new FakeClock();
        VisibleMigrationProgressMonitor monitor = new VisibleMigrationProgressMonitor(log, (Clock)clock);
        monitor.started(1);
        clock.forward(1500L, TimeUnit.MILLISECONDS);
        monitor.completed();
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"took 1s 500ms"});
    }

    private void verifySectionReportedCorrectly(AssertableLogProvider logProvider) {
        LogAssert messageMatcher = LogAssertions.assertThat((AssertableLogProvider)logProvider);
        messageMatcher.containsMessages(new String[]{"Starting upgrade of database"});
        for (int i = 10; i <= 100; i += 10) {
            messageMatcher.containsMessages(new String[]{i + "%"});
        }
        messageMatcher.containsMessages(new String[]{"Successfully finished upgrade of database"});
        messageMatcher.forClass(VisibleMigrationProgressMonitor.class).forLevel(AssertableLogProvider.Level.INFO).doesNotContainMessage("110%");
    }

    private void monitorSection(VisibleMigrationProgressMonitor monitor, String name, int max, int ... steps) {
        ProgressReporter progressReporter = monitor.startSection(name);
        progressReporter.start((long)max);
        for (int step : steps) {
            progressReporter.progress((long)step);
        }
        progressReporter.completed();
    }
}

