/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.BoltConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.HttpConnectionInfo;

class ClientConnectionInfoTest {
    ClientConnectionInfoTest() {
    }

    @Test
    void connectionDetailsForBoltQuerySource() {
        BoltConnectionInfo clientConnection = new BoltConnectionInfo("bolt-42", "neo4j-java-bolt-driver", (SocketAddress)new InetSocketAddress("127.0.0.1", 56789), (SocketAddress)new InetSocketAddress("127.0.0.1", 7687));
        String connectionDetails = clientConnection.asConnectionDetails();
        Assertions.assertEquals((Object)"bolt-session\tbolt\tneo4j-java-bolt-driver\t\tclient/127.0.0.1:56789\tserver/127.0.0.1:7687>", (Object)connectionDetails);
    }

    @Test
    void connectionDetailsForHttpQuerySource() {
        HttpConnectionInfo clientConnection = new HttpConnectionInfo("http-42", "http", (SocketAddress)new InetSocketAddress("127.0.0.1", 1337), null, "/db/neo4j/tx/45/commit");
        String connectionDetails = clientConnection.asConnectionDetails();
        Assertions.assertEquals((Object)"server-session\thttp\t127.0.0.1\t/db/neo4j/tx/45/commit", (Object)connectionDetails);
    }

    @Test
    void connectionDetailsForEmbeddedQuerySource() {
        String connectionDetails = ClientConnectionInfo.EMBEDDED_CONNECTION.asConnectionDetails();
        Assertions.assertEquals((Object)"embedded-session\t", (Object)connectionDetails);
    }
}

