/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class NodeValueClientFilterTest
implements IndexProgressor,
IndexProgressor.EntityValueClient {
    @Inject
    private RandomRule random;
    private final Read read = (Read)Mockito.mock(Read.class);
    private final List<Event> events = new ArrayList<Event>();
    private final StubNodeCursor node = new StubNodeCursor();
    private final StubPropertyCursor property = new StubPropertyCursor();

    NodeValueClientFilterTest() {
    }

    @Test
    void shouldAcceptAllNodesOnNoFilters() {
        float score = 0.42f;
        this.node.withNode(17L);
        NodeValueClientFilter filter = this.initializeFilter();
        filter.next();
        Assertions.assertTrue((boolean)filter.acceptEntity(17L, score, null));
        filter.close();
        this.assertEvents(this.initialize(0), Event.NEXT, new Event.Node(17L, score, null), Event.CLOSE);
    }

    @Test
    void shouldRejectNodeNotInUse() {
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assertions.assertFalse((boolean)filter.acceptEntity(17L, 0.42f, null));
        filter.close();
        this.assertEvents(this.initialize(12), Event.NEXT, Event.CLOSE);
    }

    @Test
    void shouldRejectNodeWithNoProperties() {
        this.node.withNode(17L);
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assertions.assertFalse((boolean)filter.acceptEntity(17L, 0.42f, null));
        filter.close();
        this.assertEvents(this.initialize(12), Event.NEXT, Event.CLOSE);
    }

    @Test
    void shouldAcceptNodeWithMatchingProperty() {
        float score = 0.42f;
        this.node.withNode(17L, new long[0], MapUtil.genericMap((Object[])new Object[]{12, Values.stringValue((String)"hello")}));
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assertions.assertTrue((boolean)filter.acceptEntity(17L, score, null));
        filter.close();
        this.assertEvents(this.initialize(12), Event.NEXT, new Event.Node(17L, score, null), Event.CLOSE);
    }

    @Test
    void shouldNotAcceptNodeWithoutMatchingProperty() {
        this.node.withNode(17L, new long[0], MapUtil.genericMap((Object[])new Object[]{7, Values.stringValue((String)"wrong")}));
        NodeValueClientFilter filter = this.initializeFilter(new IndexQuery[]{IndexQuery.exists((int)12)});
        filter.next();
        Assertions.assertFalse((boolean)filter.acceptEntity(17L, 0.42f, null));
        filter.close();
        this.assertEvents(this.initialize(12), Event.NEXT, Event.CLOSE);
    }

    @Test
    void shouldConsultProvidedAcceptingFiltersForMixOfValuesAndNoValues() {
        this.shouldConsultProvidedFilters(Function.identity(), true);
    }

    @Test
    void shouldConsultProvidedAcceptingFiltersForNullValues() {
        this.shouldConsultProvidedFilters(v -> null, true);
    }

    @Test
    void shouldConsultProvidedDenyingFiltersForMixOfValuesAndNoValues() {
        this.shouldConsultProvidedFilters(Function.identity(), false);
    }

    @Test
    void shouldConsultProvidedDenyingFiltersForNullValues() {
        this.shouldConsultProvidedFilters(v -> null, false);
    }

    private void shouldConsultProvidedFilters(Function<Value[], Value[]> filterValues, boolean filterAcceptsValue) {
        long nodeReference = 123L;
        float score = 0.42f;
        int labelId = 10;
        int slots = this.random.nextInt(3, 8);
        IndexQuery[] filters = new IndexQuery[slots];
        Value[] actualValues = new Value[slots];
        Value[] values = new Value[slots];
        HashMap<Integer, Value> properties = new HashMap<Integer, Value>();
        int[] propertyKeyIds = new int[slots];
        int filterCount = 0;
        for (int propertyKeyId = 0; propertyKeyId < slots; ++propertyKeyId) {
            actualValues[propertyKeyId] = this.random.nextValue();
            propertyKeyIds[propertyKeyId] = propertyKeyId;
            if (filterCount == 0 && propertyKeyId == slots - 1 || this.random.nextBoolean()) {
                Object filterValue = (filterAcceptsValue ? actualValues[propertyKeyId] : this.anyOtherValueThan(actualValues[propertyKeyId])).asObjectCopy();
                filters[propertyKeyId] = IndexQuery.exact((int)propertyKeyId, (Object)filterValue);
                ++filterCount;
            }
            values[propertyKeyId] = this.random.nextBoolean() ? Values.NO_VALUE : actualValues[propertyKeyId];
            properties.put(propertyKeyId, actualValues[propertyKeyId]);
        }
        this.node.withNode(nodeReference, new long[]{labelId}, properties);
        NodeValueClientFilter filter = new NodeValueClientFilter((IndexProgressor.EntityValueClient)this, (NodeCursor)this.node, (PropertyCursor)this.property, this.read, filters);
        filter.initialize(TestIndexDescriptorFactory.forLabel(labelId, propertyKeyIds), (IndexProgressor)this, null, IndexQueryConstraints.unorderedValues(), false);
        boolean accepted = filter.acceptEntity(nodeReference, score, filterValues.apply(values));
        Assertions.assertEquals((Object)filterAcceptsValue, (Object)accepted);
    }

    private Value anyOtherValueThan(Value valueToNotReturn) {
        Value candidate;
        while ((candidate = this.random.nextValue()).equalTo((Object)valueToNotReturn)) {
        }
        return candidate;
    }

    private NodeValueClientFilter initializeFilter(IndexQuery ... filters) {
        NodeValueClientFilter filter = new NodeValueClientFilter((IndexProgressor.EntityValueClient)this, (NodeCursor)this.node, (PropertyCursor)this.property, this.read, filters);
        int[] propKeyIds = new int[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            propKeyIds[i] = filters[i].propertyKeyId();
        }
        filter.initialize(TestIndexDescriptorFactory.forLabel(11, propKeyIds), (IndexProgressor)this, null, IndexQueryConstraints.unorderedValues(), false);
        return filter;
    }

    private NodeValueClientFilter initializeFilter() {
        NodeValueClientFilter filter = new NodeValueClientFilter((IndexProgressor.EntityValueClient)this, (NodeCursor)this.node, (PropertyCursor)this.property, this.read, new IndexQuery[0]);
        filter.initialize(TestIndexDescriptorFactory.forLabel(11, 0), (IndexProgressor)this, null, IndexQueryConstraints.unorderedValues(), false);
        return filter;
    }

    private void assertEvents(Event ... expected) {
        Assertions.assertEquals(new ArrayList<Event>(Arrays.asList(expected)), this.events);
    }

    private Event.Initialize initialize(int ... keys) {
        return new Event.Initialize(this, keys);
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] queries, IndexQueryConstraints constraints, boolean indexIncludesTransactionState) {
        this.events.add(new Event.Initialize(progressor, descriptor.schema().getPropertyIds()));
    }

    public boolean acceptEntity(long reference, float score, Value[] values) {
        this.events.add(new Event.Node(reference, score, values));
        return true;
    }

    public boolean needsValues() {
        return true;
    }

    public boolean next() {
        this.events.add(Event.NEXT);
        return true;
    }

    public void close() {
        this.events.add(Event.CLOSE);
    }

    private static abstract class Event {
        static final Event CLOSE = new Event(){

            public String toString() {
                return "CLOSE";
            }
        };
        static final Event NEXT = new Event(){

            public String toString() {
                return "NEXT";
            }
        };

        private Event() {
        }

        public final boolean equals(Object other) {
            return this.toString().equals(other.toString());
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }

        static class Node
        extends Event {
            final long reference;
            final float score;
            final Value[] values;

            Node(long reference, float score, Value[] values) {
                this.reference = reference;
                this.score = score;
                this.values = values;
            }

            public String toString() {
                String scoreHex = Integer.toHexString(Float.floatToRawIntBits(this.score));
                return "Node(" + this.reference + ", " + this.score + " (" + scoreHex + ")," + Arrays.toString(this.values) + ")";
            }
        }

        static class Initialize
        extends Event {
            final transient IndexProgressor progressor;
            final int[] keys;

            Initialize(IndexProgressor progressor, int[] keys) {
                this.progressor = progressor;
                this.keys = keys;
            }

            public String toString() {
                return "INITIALIZE(" + Arrays.toString(this.keys) + ")";
            }
        }
    }
}

