/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.time.Clocks;

class LockManagerImplTest {
    LockManagerImplTest() {
    }

    @Test
    void shouldAllowGetReadWriteLocks() {
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockResource node2 = new LockResource((ResourceType)ResourceTypes.NODE, 2L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = LockManagerImplTest.createLockManager();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lockManager.getReadLock(LockTracer.NONE, node1, (Object)lockTransaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lockManager.getReadLock(LockTracer.NONE, node2, (Object)lockTransaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lockManager.getWriteLock(LockTracer.NONE, node2, (Object)lockTransaction));
        lockManager.releaseReadLock((Object)node1, (Object)lockTransaction);
        lockManager.releaseReadLock((Object)node2, (Object)lockTransaction);
        lockManager.releaseWriteLock((Object)node2, (Object)lockTransaction);
        int lockCount = LockManagerImplTest.countLocks(lockManager);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)lockCount);
    }

    @Test
    void shouldNotBePossibleReleaseNotExistingLock() {
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = LockManagerImplTest.createLockManager();
        LockNotFoundException e = (LockNotFoundException)org.junit.jupiter.api.Assertions.assertThrows(LockNotFoundException.class, () -> lockManager.releaseReadLock((Object)node1, (Object)lockTransaction));
        Assertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"Lock not found for: ");
    }

    @Test
    void shouldCleanupNotUsedLocks() {
        LockResource node = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = LockManagerImplTest.createLockManager();
        lockManager.getWriteLock(LockTracer.NONE, node, (Object)lockTransaction);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lockManager.tryReadLock(node, (Object)lockTransaction));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)LockManagerImplTest.countLocks(lockManager));
        lockManager.releaseWriteLock((Object)node, (Object)lockTransaction);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)LockManagerImplTest.countLocks(lockManager));
        lockManager.releaseReadLock((Object)node, (Object)lockTransaction);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)LockManagerImplTest.countLocks(lockManager));
    }

    @Test
    void shouldReleaseNotAcquiredLocks() {
        LockResource node = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        RWLock rwLock = (RWLock)Mockito.mock(RWLock.class);
        MockedLockLockManager lockManager = new MockedLockLockManager(new RagManager(), rwLock);
        lockManager.tryReadLock(node, lockTransaction);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)LockManagerImplTest.countLocks(lockManager));
    }

    private static LockManagerImpl createLockManager() {
        return new LockManagerImpl(new RagManager(), Config.defaults(), Clocks.systemClock());
    }

    private static int countLocks(LockManagerImpl lockManager) {
        int[] counter = new int[1];
        lockManager.accept(element -> {
            counter[0] = counter[0] + 1;
            return false;
        });
        return counter[0];
    }

    private static class MockedLockLockManager
    extends LockManagerImpl {
        private final RWLock lock;

        MockedLockLockManager(RagManager ragManager, RWLock lock) {
            super(ragManager, Config.defaults(), Clocks.systemClock());
            this.lock = lock;
        }

        protected RWLock createLock(LockResource resource) {
            return this.lock;
        }
    }
}

