/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssert;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;

@EphemeralPageCacheExtension
abstract class NativeIndexProviderTests {
    private static final int indexId = 1;
    private static final int labelId = 1;
    private static final int propId = 1;
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    private final AssertableLogProvider logging = new AssertableLogProvider();
    private final IndexProvider.Monitor monitor = new LoggingMonitor(this.logging.getLog("test"));
    private final ProviderFactory factory;
    private final InternalIndexState expectedStateOnNonExistingSubIndex;
    private final Value someValue;
    private IndexProvider provider;

    NativeIndexProviderTests(ProviderFactory factory, InternalIndexState expectedStateOnNonExistingSubIndex, Value someValue) {
        this.factory = factory;
        this.expectedStateOnNonExistingSubIndex = expectedStateOnNonExistingSubIndex;
        this.someValue = someValue;
    }

    @BeforeEach
    void setup() throws IOException {
        File nativeSchemaIndexStoreDirectory = this.newProvider().directoryStructure().rootDirectory();
        this.fs.mkdirs(nativeSchemaIndexStoreDirectory);
    }

    @Test
    void getPopulatorMustThrowIfInReadOnlyMode() {
        this.provider = this.newReadOnlyProvider();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    @Test
    void shouldNotCheckConflictsWhenApplyingUpdatesInOnlineAccessor() throws IOException, IndexEntryConflictException {
        this.provider = this.newProvider();
        IndexDescriptor descriptor = this.descriptorUnique();
        try (IndexAccessor accessor = this.provider.getOnlineAccessor(descriptor, NativeIndexProviderTests.samplingConfig());
             IndexUpdater indexUpdater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
            indexUpdater.process(IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)descriptor.schema(), (Value[])new Value[]{this.someValue}));
            indexUpdater.process(IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)descriptor.schema(), (Value[])new Value[]{this.someValue}));
        }
    }

    @Test
    void getPopulationFailureReturnEmptyStringIfNoFailure() {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        populator.close(true, PageCursorTracer.NULL);
        Assertions.assertEquals((Object)"", (Object)this.provider.getPopulationFailure(this.descriptor(), PageCursorTracer.NULL));
    }

    @Test
    void getPopulationFailureReturnEmptyStringIfFailureOnOtherIndex() {
        this.provider = this.newProvider();
        int nonFailedIndexId = 1;
        IndexPopulator nonFailedPopulator = this.provider.getPopulator(this.descriptor(nonFailedIndexId), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        nonFailedPopulator.create();
        nonFailedPopulator.close(true, PageCursorTracer.NULL);
        int failedIndexId = 2;
        IndexPopulator failedPopulator = this.provider.getPopulator(this.descriptor(failedIndexId), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        failedPopulator.create();
        failedPopulator.markAsFailed("failure");
        failedPopulator.close(false, PageCursorTracer.NULL);
        String populationFailure = this.provider.getPopulationFailure(this.descriptor(nonFailedIndexId), PageCursorTracer.NULL);
        Assertions.assertEquals((Object)"", (Object)populationFailure);
    }

    @Test
    void getPopulationFailureMustReturnReportedFailure() {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        String failureMessage = "fail";
        populator.markAsFailed(failureMessage);
        populator.close(false, PageCursorTracer.NULL);
        String populationFailure = this.provider.getPopulationFailure(this.descriptor(), PageCursorTracer.NULL);
        LogAssertions.assertThat((String)populationFailure).isEqualTo(failureMessage);
    }

    @Test
    void getPopulationFailureMustReturnReportedFailuresForDifferentIndexIds() {
        this.provider = this.newProvider();
        int first = 1;
        int second = 2;
        int third = 3;
        IndexPopulator firstPopulator = this.provider.getPopulator(this.descriptor(first), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        firstPopulator.create();
        IndexPopulator secondPopulator = this.provider.getPopulator(this.descriptor(second), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        secondPopulator.create();
        IndexPopulator thirdPopulator = this.provider.getPopulator(this.descriptor(third), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        thirdPopulator.create();
        String firstFailure = "first failure";
        firstPopulator.markAsFailed(firstFailure);
        firstPopulator.close(false, PageCursorTracer.NULL);
        secondPopulator.close(true, PageCursorTracer.NULL);
        String thirdFailure = "third failure";
        thirdPopulator.markAsFailed(thirdFailure);
        thirdPopulator.close(false, PageCursorTracer.NULL);
        LogAssertions.assertThat((String)this.provider.getPopulationFailure(this.descriptor(first), PageCursorTracer.NULL)).isEqualTo(firstFailure);
        LogAssertions.assertThat((String)this.provider.getPopulationFailure(this.descriptor(third), PageCursorTracer.NULL)).isEqualTo(thirdFailure);
        Assertions.assertEquals((Object)"", (Object)this.provider.getPopulationFailure(this.descriptor(second), PageCursorTracer.NULL));
    }

    @Test
    void getPopulationFailureMustPersistReportedFailure() {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        String failureMessage = "fail";
        populator.markAsFailed(failureMessage);
        populator.close(false, PageCursorTracer.NULL);
        this.provider = this.newProvider();
        String populationFailure = this.provider.getPopulationFailure(this.descriptor(), PageCursorTracer.NULL);
        LogAssertions.assertThat((String)populationFailure).isEqualTo(failureMessage);
    }

    @Test
    void shouldReportCorrectInitialStateIfIndexDoesntExist() {
        this.provider = this.newProvider();
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), PageCursorTracer.NULL);
        Assertions.assertEquals((Object)this.expectedStateOnNonExistingSubIndex, (Object)state);
        LogAssert logAssert = LogAssertions.assertThat((AssertableLogProvider)this.logging);
        if (InternalIndexState.POPULATING == this.expectedStateOnNonExistingSubIndex) {
            logAssert.containsMessages(new String[]{"Failed to open index"});
        } else {
            logAssert.doesNotContainMessage("Failed to open index");
        }
    }

    @Test
    void shouldReportInitialStateAsPopulatingIfPopulationStartedButIncomplete() {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), PageCursorTracer.NULL);
        Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)state);
        populator.close(true, PageCursorTracer.NULL);
    }

    @Test
    void shouldReportInitialStateAsFailedIfMarkedAsFailed() {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        populator.markAsFailed("Just some failure");
        populator.close(false, PageCursorTracer.NULL);
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), PageCursorTracer.NULL);
        Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)state);
    }

    @Test
    void shouldReportInitialStateAsOnlineIfPopulationCompletedSuccessfully() {
        this.provider = this.newProvider();
        IndexPopulator populator = this.provider.getPopulator(this.descriptor(), NativeIndexProviderTests.samplingConfig(), ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        populator.close(true, PageCursorTracer.NULL);
        InternalIndexState state = this.provider.getInitialState(this.descriptor(), PageCursorTracer.NULL);
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)state);
    }

    private IndexProvider newProvider(boolean readOnly) {
        return this.factory.create(this.pageCache, this.fs, IndexDirectoryStructure.directoriesByProvider((File)this.testDirectory.absolutePath()), this.monitor, RecoveryCleanupWorkCollector.immediate(), readOnly);
    }

    private IndexProvider newProvider() {
        return this.newProvider(false);
    }

    private IndexProvider newReadOnlyProvider() {
        return this.newProvider(true);
    }

    private static IndexSamplingConfig samplingConfig() {
        return new IndexSamplingConfig(Config.defaults());
    }

    private IndexDescriptor descriptor() {
        return this.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index").materialise(1L));
    }

    private IndexDescriptor descriptor(long indexId) {
        return this.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index_" + indexId).materialise(indexId));
    }

    private IndexDescriptor descriptorUnique() {
        return this.completeConfiguration(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("constraint").materialise(1L));
    }

    private IndexDescriptor completeConfiguration(IndexDescriptor indexDescriptor) {
        return this.provider.completeConfiguration(indexDescriptor);
    }

    @FunctionalInterface
    static interface ProviderFactory {
        public IndexProvider create(PageCache var1, FileSystemAbstraction var2, IndexDirectoryStructure.Factory var3, IndexProvider.Monitor var4, RecoveryCleanupWorkCollector var5, boolean var6);
    }
}

