/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.FilteringNativeHitIterator;
import org.neo4j.kernel.impl.index.schema.ResultCursor;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

@ExtendWith(value={RandomExtension.class})
class FilteringNativeHitIteratorTest {
    @Inject
    private RandomRule random;

    FilteringNativeHitIteratorTest() {
    }

    @Test
    void shouldFilterResults() {
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            keys.add(this.random.nextAlphaNumericString());
        }
        ResultCursor cursor = new ResultCursor(keys.iterator());
        IndexQuery[] predicates = new IndexQuery[]{(IndexQuery)Mockito.mock(IndexQuery.class)};
        Predicate<String> filter = string -> string.contains("a");
        Mockito.when((Object)predicates[0].acceptsValue((Value)ArgumentMatchers.any(Value.class))).then(invocation -> filter.test(((TextValue)invocation.getArgument(0)).stringValue()));
        FilteringNativeHitIterator iterator = new FilteringNativeHitIterator((Seeker)cursor, new ArrayList(), predicates);
        ArrayList<Long> result = new ArrayList<Long>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        for (int i = 0; i < keys.size(); ++i) {
            if (!filter.test((String)keys.get(i))) continue;
            Assertions.assertTrue((boolean)result.remove((Object)i));
        }
        Assertions.assertTrue((boolean)result.isEmpty());
    }
}

