/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.trace;

import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;

class TraceProviderFactoryTest {
    TraceProviderFactoryTest() {
    }

    @Test
    void disabledTracerCreation() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.transaction_tracing_level, (Object)GraphDatabaseSettings.TransactionTracingLevel.DISABLED);
        TraceProvider traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        for (int i = 0; i < 100; ++i) {
            Assertions.assertSame((Object)TransactionInitializationTrace.NONE, (Object)traceProvider.getTraceInfo());
        }
    }

    @Test
    void samplingTracerCreation() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.transaction_tracing_level, (Object)GraphDatabaseSettings.TransactionTracingLevel.SAMPLE);
        config.set(GraphDatabaseSettings.transaction_sampling_percentage, (Object)50);
        TraceProvider traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        HashSet<TransactionInitializationTrace> traces = new HashSet<TransactionInitializationTrace>();
        for (int i = 0; i < 100; ++i) {
            TransactionInitializationTrace traceInfo = traceProvider.getTraceInfo();
            traces.add(traceInfo);
        }
        Assertions.assertTrue((boolean)traces.contains(TransactionInitializationTrace.NONE));
        Assertions.assertTrue((traces.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    void allTransactionsTracerCreation() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.transaction_tracing_level, (Object)GraphDatabaseSettings.TransactionTracingLevel.ALL);
        TraceProvider traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        for (int i = 0; i < 100; ++i) {
            Assertions.assertNotEquals((Object)TransactionInitializationTrace.NONE, (Object)traceProvider.getTraceInfo());
        }
    }
}

