/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.state.AppendOnlyValuesContainer;
import org.neo4j.kernel.impl.api.state.TestMemoryAllocator;
import org.neo4j.kernel.impl.api.state.ValuesContainer;
import org.neo4j.kernel.impl.api.state.ValuesMap;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class ValuesMapTest {
    @Inject
    private RandomRule rnd;
    private final ValuesMap map = ValuesMapTest.newMap();

    ValuesMapTest() {
    }

    @Test
    void putGet() {
        this.map.put(0L, (Value)Values.intValue((int)10));
        this.map.put(1L, (Value)Values.intValue((int)11));
        this.map.put(2L, (Value)Values.intValue((int)12));
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.get(0L));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.get(1L));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.get(2L));
        Assertions.assertNull((Object)this.map.get(3L));
    }

    @Test
    void putAll() {
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.get(0L));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.get(1L));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.get(2L));
    }

    @Test
    void getIfAbsent() {
        Assertions.assertEquals((Object)Values.intValue((int)-1), (Object)this.map.getIfAbsent(0L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        Assertions.assertEquals((Object)Values.intValue((int)-1), (Object)this.map.getIfAbsent(1L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        Assertions.assertEquals((Object)Values.intValue((int)-1), (Object)this.map.getIfAbsent(2L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        Assertions.assertEquals((Object)Values.intValue((int)-1), (Object)this.map.getIfAbsent(3L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsent(0L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsent(1L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsent(2L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
        Assertions.assertEquals((Object)Values.intValue((int)-1), (Object)this.map.getIfAbsent(3L, (Function0 & Serializable)() -> Values.intValue((int)-1)));
    }

    @Test
    void getIfAbsentPut() {
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPut(0L, (Value)Values.intValue((int)10)));
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPut(0L, (Value)Values.intValue((int)100)));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPut(1L, (Value)Values.intValue((int)11)));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPut(1L, (Value)Values.intValue((int)110)));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPut(2L, (Value)Values.intValue((int)12)));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPut(2L, (Value)Values.intValue((int)120)));
    }

    @Test
    void getIfAbsentPut_Supplier() {
        Function0 supplier = (Function0)Mockito.mock(Function0.class);
        ((Function0)Mockito.doReturn((Object)Values.intValue((int)10), (Object[])new Object[]{Values.intValue((int)11), Values.intValue((int)12)}).when((Object)supplier)).value();
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPut(0L, supplier));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPut(1L, supplier));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPut(2L, supplier));
        ((Function0)Mockito.verify((Object)supplier, (VerificationMode)VerificationModeFactory.times((int)3))).value();
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPut(0L, supplier));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPut(1L, supplier));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPut(2L, supplier));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{supplier});
    }

    @Test
    void getIfAbsentPutWithKey() {
        LongToObjectFunction function = (LongToObjectFunction)Mockito.spy((Object)new LongToObjectFunction<Value>(){

            public Value valueOf(long x) {
                return Values.intValue((int)(10 + (int)x));
            }
        });
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPutWithKey(0L, function));
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPutWithKey(0L, function));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPutWithKey(1L, function));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPutWithKey(1L, function));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPutWithKey(2L, function));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPutWithKey(2L, function));
        ((LongToObjectFunction)Mockito.verify((Object)function)).valueOf(ArgumentMatchers.eq((long)0L));
        ((LongToObjectFunction)Mockito.verify((Object)function)).valueOf(ArgumentMatchers.eq((long)1L));
        ((LongToObjectFunction)Mockito.verify((Object)function)).valueOf(ArgumentMatchers.eq((long)2L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{function});
    }

    @Test
    void getIfAbsentPutWith() {
        Function function = (Function)Mockito.spy((Object)new Function<String, Value>(){

            public Value valueOf(String s) {
                return Values.intValue((int)Integer.valueOf(s));
            }
        });
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPutWith(0L, function, (Object)"10"));
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.getIfAbsentPutWith(0L, function, (Object)"10"));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPutWith(1L, function, (Object)"11"));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.getIfAbsentPutWith(1L, function, (Object)"11"));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPutWith(2L, function, (Object)"12"));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.getIfAbsentPutWith(2L, function, (Object)"12"));
        ((Function)Mockito.verify((Object)function)).valueOf((Object)((String)ArgumentMatchers.eq((Object)"10")));
        ((Function)Mockito.verify((Object)function)).valueOf((Object)((String)ArgumentMatchers.eq((Object)"11")));
        ((Function)Mockito.verify((Object)function)).valueOf((Object)((String)ArgumentMatchers.eq((Object)"12")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{function});
    }

    @Test
    void putOverwrite() {
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        Assertions.assertEquals((Object)Values.intValue((int)10), (Object)this.map.get(0L));
        Assertions.assertEquals((Object)Values.intValue((int)11), (Object)this.map.get(1L));
        Assertions.assertEquals((Object)Values.intValue((int)12), (Object)this.map.get(2L));
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)20), (long)1L, (Object)Values.intValue((int)21), (long)2L, (Object)Values.intValue((int)22)));
        Assertions.assertEquals((Object)Values.intValue((int)20), (Object)this.map.get(0L));
        Assertions.assertEquals((Object)Values.intValue((int)21), (Object)this.map.get(1L));
        Assertions.assertEquals((Object)Values.intValue((int)22), (Object)this.map.get(2L));
    }

    @Test
    void size() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put(0L, (Value)Values.intValue((int)10));
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.put(1L, (Value)Values.intValue((int)11));
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.put(2L, (Value)Values.intValue((int)12));
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.put(0L, (Value)Values.intValue((int)20));
        this.map.put(1L, (Value)Values.intValue((int)20));
        this.map.put(2L, (Value)Values.intValue((int)20));
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.remove(0L);
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.remove(1L);
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.remove(2L);
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    void containsKey() {
        Assertions.assertFalse((boolean)this.map.containsKey(0L));
        Assertions.assertFalse((boolean)this.map.containsKey(1L));
        Assertions.assertFalse((boolean)this.map.containsKey(2L));
        this.map.put(0L, (Value)Values.intValue((int)10));
        Assertions.assertTrue((boolean)this.map.containsKey(0L));
        this.map.put(1L, (Value)Values.intValue((int)11));
        Assertions.assertTrue((boolean)this.map.containsKey(1L));
        this.map.put(2L, (Value)Values.intValue((int)12));
        Assertions.assertTrue((boolean)this.map.containsKey(2L));
    }

    @Test
    void forEachKey() {
        LongProcedure consumer = (LongProcedure)Mockito.mock(LongProcedure.class);
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        this.map.forEachKey(consumer);
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)0L));
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)1L));
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)2L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void forEachValue() {
        Procedure consumer = (Procedure)Mockito.mock(Procedure.class);
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        this.map.forEachValue(consumer);
        ((Procedure)Mockito.verify((Object)consumer)).value((Object)((Value)ArgumentMatchers.eq((Object)Values.intValue((int)10))));
        ((Procedure)Mockito.verify((Object)consumer)).value((Object)((Value)ArgumentMatchers.eq((Object)Values.intValue((int)11))));
        ((Procedure)Mockito.verify((Object)consumer)).value((Object)((Value)ArgumentMatchers.eq((Object)Values.intValue((int)12))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void forEachKeyValue() {
        LongObjectProcedure consumer = (LongObjectProcedure)Mockito.mock(LongObjectProcedure.class);
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        this.map.forEachKeyValue(consumer);
        ((LongObjectProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)0L), (Object)((Value)ArgumentMatchers.eq((Object)Values.intValue((int)10))));
        ((LongObjectProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)1L), (Object)((Value)ArgumentMatchers.eq((Object)Values.intValue((int)11))));
        ((LongObjectProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)2L), (Object)((Value)ArgumentMatchers.eq((Object)Values.intValue((int)12))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void clear() {
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.putAll((LongObjectMap)LongObjectHashMap.newWithKeysValues((long)0L, (Object)Values.intValue((int)10), (long)1L, (Object)Values.intValue((int)11), (long)2L, (Object)Values.intValue((int)12)));
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    void randomizedWithSharedValuesContainer() {
        int i;
        int MAPS = 13;
        int COUNT = 10000 + this.rnd.nextInt(1000);
        AppendOnlyValuesContainer valuesContainer = new AppendOnlyValuesContainer((MemoryAllocator)new TestMemoryAllocator(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ArrayList<ValuesMap> actualMaps = new ArrayList<ValuesMap>();
        ArrayList<LongObjectHashMap> expectedMaps = new ArrayList<LongObjectHashMap>();
        for (i = 0; i < 13; ++i) {
            actualMaps.add(ValuesMapTest.newMap(valuesContainer));
            expectedMaps.add(new LongObjectHashMap());
        }
        for (i = 0; i < 13; ++i) {
            this.put(COUNT, (ValuesMap)actualMaps.get(i), (MutableLongObjectMap<Value>)((MutableLongObjectMap)expectedMaps.get(i)));
        }
        for (i = 0; i < 13; ++i) {
            this.remove(COUNT, (ValuesMap)actualMaps.get(i), (MutableLongObjectMap<Value>)((MutableLongObjectMap)expectedMaps.get(i)));
        }
        for (i = 0; i < 13; ++i) {
            MutableLongObjectMap expected = (MutableLongObjectMap)expectedMaps.get(i);
            ValuesMap actual = (ValuesMap)actualMaps.get(i);
            expected.forEachKeyValue((LongObjectProcedure & Serializable)(k, v) -> Assertions.assertEquals((Object)v, (Object)actual.get(k)));
        }
    }

    private void remove(int count, ValuesMap actualMap, MutableLongObjectMap<Value> expectedMap) {
        for (int i = 0; i < count / 2; ++i) {
            long key = this.rnd.nextLong((long)count);
            Value value = this.rnd.randomValues().nextValue();
            actualMap.put(key, value);
            expectedMap.put(key, (Object)value);
        }
    }

    private void put(int count, ValuesMap actualMap, MutableLongObjectMap<Value> expectedMap) {
        for (int i = 0; i < count * 2; ++i) {
            long key = this.rnd.nextLong((long)count);
            Value value = this.rnd.randomValues().nextValue();
            actualMap.put(key, value);
            expectedMap.put(key, (Object)value);
        }
    }

    private static ValuesMap newMap() {
        return ValuesMapTest.newMap(new AppendOnlyValuesContainer((MemoryAllocator)new TestMemoryAllocator(), (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    private static ValuesMap newMap(AppendOnlyValuesContainer valuesContainer) {
        return new ValuesMap((MutableLongLongMap)new LongLongHashMap(), (ValuesContainer)valuesContainer);
    }
}

