/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.annotations.documented.ReporterFactories;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@EphemeralPageCacheExtension
class IndexStatisticsStoreTest {
    private LifeSupport lifeSupport = new LifeSupport();
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    private IndexStatisticsStore store;
    private final PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;

    IndexStatisticsStoreTest() {
    }

    @BeforeEach
    void start() {
        this.store = this.openStore(this.pageCacheTracer, "stats");
        this.lifeSupport.start();
    }

    @AfterEach
    void stop() {
        this.lifeSupport.shutdown();
    }

    private IndexStatisticsStore openStore(PageCacheTracer pageCacheTracer, String fileName) {
        IndexStatisticsStore statisticsStore = new IndexStatisticsStore(this.pageCache, this.testDirectory.file(fileName, new String[0]), RecoveryCleanupWorkCollector.immediate(), false, pageCacheTracer);
        return (IndexStatisticsStore)this.lifeSupport.add((Lifecycle)statisticsStore);
    }

    @Test
    void tracePageCacheAccessOnConsistencyCheck() throws IOException {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        IndexStatisticsStore store = this.openStore((PageCacheTracer)cacheTracer, "consistencyCheck");
        try (PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer("tracePageCacheAccessOnConsistencyCheck");){
            for (int i = 0; i < 100; ++i) {
                store.replaceStats((long)i, new IndexSample());
            }
            store.checkpoint(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
            store.consistencyCheck(ReporterFactories.noopReporterFactory(), cursorTracer);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(16L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(16L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(16L);
        }
    }

    @Test
    void tracePageCacheAccessOnStatisticStoreInitialisation() {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        Assertions.assertThat((long)cacheTracer.pins()).isZero();
        Assertions.assertThat((long)cacheTracer.unpins()).isZero();
        Assertions.assertThat((long)cacheTracer.hits()).isZero();
        Assertions.assertThat((long)cacheTracer.faults()).isZero();
        this.openStore((PageCacheTracer)cacheTracer, "tracedStats");
        Assertions.assertThat((long)cacheTracer.faults()).isEqualTo(5L);
        Assertions.assertThat((long)cacheTracer.pins()).isEqualTo(14L);
        Assertions.assertThat((long)cacheTracer.unpins()).isEqualTo(14L);
        Assertions.assertThat((long)cacheTracer.hits()).isEqualTo(9L);
    }

    @Test
    void tracePageCacheAccessOnCheckpoint() throws IOException {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        IndexStatisticsStore store = this.openStore((PageCacheTracer)cacheTracer, "checkpoint");
        try (PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer("tracePageCacheAccessOnCheckpoint");){
            for (int i = 0; i < 100; ++i) {
                store.replaceStats((long)i, new IndexSample());
            }
            store.checkpoint(IOLimiter.UNLIMITED, cursorTracer);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(43L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(43L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(35L);
            Assertions.assertThat((long)cursorTracer.faults()).isEqualTo(8L);
        }
    }

    @Test
    void shouldReplaceIndexSample() {
        long indexId = 4L;
        this.replaceAndVerifySample(indexId, new IndexSample(456L, 123L, 456L, 3L));
        this.replaceAndVerifySample(indexId, new IndexSample(555L, 444L, 550L, 0L));
    }

    @Test
    void shouldIncrementIndexUpdates() {
        long indexId = 4L;
        IndexSample initialSample = new IndexSample(456L, 5L, 200L, 123L);
        this.store.replaceStats(indexId, initialSample);
        int addedUpdates = 5;
        this.store.incrementIndexUpdates(indexId, (long)addedUpdates);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new IndexSample(initialSample.indexSize(), initialSample.uniqueValues(), initialSample.sampleSize(), initialSample.updates() + (long)addedUpdates), (Object)this.store.indexSample(indexId));
    }

    @Test
    void shouldStoreDataOnCheckpoint() throws IOException {
        long indexId1 = 1L;
        long indexId2 = 2L;
        IndexSample sample1 = new IndexSample(500L, 100L, 200L, 25L);
        IndexSample sample2 = new IndexSample(501L, 101L, 201L, 26L);
        this.store.replaceStats(indexId1, sample1);
        this.store.replaceStats(indexId2, sample2);
        this.restartStore();
        org.junit.jupiter.api.Assertions.assertEquals((Object)sample1, (Object)this.store.indexSample(indexId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)sample2, (Object)this.store.indexSample(indexId2));
    }

    private void restartStore() throws IOException {
        this.store.checkpoint(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
        this.lifeSupport.shutdown();
        this.lifeSupport = new LifeSupport();
        this.store = this.openStore(this.pageCacheTracer, "stats");
        this.lifeSupport.start();
    }

    @Test
    void shouldAllowMultipleThreadsIncrementIndexUpdates() throws Throwable {
        long indexId = 5L;
        Race race = new Race();
        int contestants = 20;
        int delta = 3;
        this.store.replaceStats(indexId, new IndexSample(0L, 0L, 0L));
        race.addContestants(contestants, () -> this.store.incrementIndexUpdates(indexId, (long)delta), 1);
        race.go();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new IndexSample(0L, 0L, 0L, (long)(contestants * delta)), (Object)this.store.indexSample(indexId));
    }

    @Test
    void shouldHandleConcurrentUpdatesWithCheckpointing() throws Throwable {
        Race race = new Race();
        AtomicBoolean checkpointDone = new AtomicBoolean();
        int contestantsPerIndex = 5;
        int indexes = 3;
        int delta = 5;
        AtomicIntegerArray expected = new AtomicIntegerArray(indexes);
        race.addContestant(Race.throwing(() -> {
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(5L);
                this.store.checkpoint(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
            }
            checkpointDone.set(true);
        }));
        int i = 0;
        while (i < indexes) {
            int indexId = i++;
            this.store.replaceStats((long)indexId, new IndexSample(0L, 0L, 0L));
            race.addContestants(contestantsPerIndex, () -> {
                while (!checkpointDone.get()) {
                    this.store.incrementIndexUpdates((long)indexId, (long)delta);
                    expected.addAndGet(indexId, delta);
                }
            });
        }
        race.go();
        for (i = 0; i < indexes; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)new IndexSample(0L, 0L, 0L, (long)expected.get(i)), (Object)this.store.indexSample((long)i));
        }
        this.restartStore();
        for (i = 0; i < indexes; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)new IndexSample(0L, 0L, 0L, (long)expected.get(i)), (Object)this.store.indexSample((long)i));
        }
    }

    @Test
    void shouldNotStartWithoutFileIfReadOnly() {
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(this.pageCache, this.testDirectory.file("non-existing", new String[0]), RecoveryCleanupWorkCollector.immediate(), true, PageCacheTracer.NULL);
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> ((IndexStatisticsStore)indexStatisticsStore).init());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof NoSuchFileException));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof TreeFileNotFoundException));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof IllegalStateException));
    }

    @Test
    void shouldNotReplaceStatsIfReadOnly() throws IOException {
        this.assertOperationThrowInReadOnlyMode(iss -> () -> iss.replaceStats(1L, new IndexSample(1L, 1L, 1L)));
    }

    @Test
    void shouldNotRemoveIndexIfReadOnly() throws IOException {
        this.assertOperationThrowInReadOnlyMode(iss -> () -> iss.removeIndex(1L));
    }

    @Test
    void shouldNotIncrementIndexUpdatesIfReadOnly() throws IOException {
        this.assertOperationThrowInReadOnlyMode(iss -> () -> iss.incrementIndexUpdates(1L, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOperationThrowInReadOnlyMode(Function<IndexStatisticsStore, Executable> operation) throws IOException {
        File file = this.testDirectory.file("existing", new String[0]);
        IndexStatisticsStore store = new IndexStatisticsStore(this.pageCache, file, RecoveryCleanupWorkCollector.immediate(), false, PageCacheTracer.NULL);
        try {
            store.init();
        }
        finally {
            store.shutdown();
        }
        IndexStatisticsStore readOnlyStore = new IndexStatisticsStore(this.pageCache, file, RecoveryCleanupWorkCollector.immediate(), true, PageCacheTracer.NULL);
        try {
            readOnlyStore.init();
            UnsupportedOperationException e = (UnsupportedOperationException)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)operation.apply(readOnlyStore));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Can not write to index statistics store while in read only mode.", (Object)e.getMessage());
        }
        finally {
            readOnlyStore.shutdown();
        }
    }

    private void replaceAndVerifySample(long indexId, IndexSample indexSample) {
        this.store.replaceStats(indexId, indexSample);
        org.junit.jupiter.api.Assertions.assertEquals((Object)indexSample, (Object)this.store.indexSample(indexId));
    }
}

