/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.function.IntPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexPopulationTest {
    IndexPopulationTest() {
    }

    @Test
    void mustFlipToFailedIfFailureToApplyLastBatchWhileFlipping() throws Exception {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexStoreView.Adaptor storeView = this.emptyIndexStoreViewThatProcessUpdates();
        IndexPopulator.Adapter populator = this.emptyPopulatorWithThrowingUpdater();
        IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
        FailedIndexProxy failedProxy = this.failedIndexProxy((MinimalIndexAccessor)populator, indexStatisticsStore);
        OnlineIndexProxy onlineProxy = this.onlineIndexProxy(indexStatisticsStore);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(() -> onlineProxy);
        InMemoryTokens tokens = new InMemoryTokens();
        MultipleIndexPopulator multipleIndexPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, (LogProvider)logProvider, EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), indexStatisticsStore, JobSchedulerFactory.createInitialisedScheduler(), (TokenNameLookup)tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        MultipleIndexPopulator.IndexPopulation indexPopulation = multipleIndexPopulator.addPopulator((IndexPopulator)populator, this.dummyMeta(), flipper, t -> failedProxy, "userDescription");
        multipleIndexPopulator.queueConcurrentUpdate(this.someUpdate());
        multipleIndexPopulator.createStoreScan(PageCursorTracer.NULL).run();
        indexPopulation.flip(false, PageCursorTracer.NULL);
        Assertions.assertSame((Object)InternalIndexState.FAILED, (Object)flipper.getState(), (String)"flipper should have flipped to failing proxy");
    }

    private OnlineIndexProxy onlineIndexProxy(IndexStatisticsStore indexStatisticsStore) {
        return new OnlineIndexProxy(this.dummyMeta(), IndexAccessor.EMPTY, indexStatisticsStore, false);
    }

    private FailedIndexProxy failedIndexProxy(MinimalIndexAccessor minimalIndexAccessor, IndexStatisticsStore indexStatisticsStore) {
        return new FailedIndexProxy(this.dummyMeta(), "userDescription", minimalIndexAccessor, IndexPopulationFailure.failure((String)"failure"), indexStatisticsStore, (LogProvider)NullLogProvider.getInstance());
    }

    private IndexPopulator.Adapter emptyPopulatorWithThrowingUpdater() {
        return new IndexPopulator.Adapter(){

            public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, PageCursorTracer cursorTracer) {
                return new IndexUpdater(){

                    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                        throw new IndexEntryConflictException(0L, 1L, new Value[]{Values.numberValue((Number)0)});
                    }

                    public void close() {
                    }
                };
            }
        };
    }

    private IndexStoreView.Adaptor emptyIndexStoreViewThatProcessUpdates() {
        return new IndexStoreView.Adaptor(){

            public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor, Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
                return new StoreScan(){

                    public void run() {
                    }

                    public void stop() {
                    }

                    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate update, long currentlyIndexedNodeId) {
                        if (update.getEntityId() <= currentlyIndexedNodeId) {
                            updater.process(update);
                        }
                    }

                    public PopulationProgress getProgress() {
                        return null;
                    }
                };
            }
        };
    }

    private IndexDescriptor dummyMeta() {
        return TestIndexDescriptorFactory.forLabel(0, 0);
    }

    private IndexEntryUpdate<LabelSchemaDescriptor> someUpdate() {
        return IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0}), (Value[])new Value[]{Values.numberValue((Number)0)});
    }
}

