/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.OtherThreadExecutor;

class FlippableIndexProxyTest {
    FlippableIndexProxyTest() {
    }

    @Test
    void shouldBeAbleToSwitchDelegate() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy other = SchemaIndexTestHelper.mockIndexProxy();
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.setFlipTarget(FlippableIndexProxyTest.singleProxy(other));
        delegate.flip(FlippableIndexProxyTest.noOp(), null);
        delegate.drop();
        ((IndexProxy)Mockito.verify((Object)other)).drop();
    }

    @Test
    void shouldNotBeAbleToFlipAfterClosed() throws Exception {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxyFactory indexContextFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.close(PageCursorTracer.NULL);
        delegate.setFlipTarget(indexContextFactory);
        Assertions.assertThrows(IndexProxyAlreadyClosedKernelException.class, () -> delegate.flip(FlippableIndexProxyTest.noOp(), null));
    }

    @Test
    void shouldNotBeAbleToFlipAfterDrop() {
        IndexProxy actual = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy failed = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxyFactory indexContextFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FlippableIndexProxy delegate = new FlippableIndexProxy(actual);
        delegate.setFlipTarget(indexContextFactory);
        delegate.drop();
        Assertions.assertThrows(IndexProxyAlreadyClosedKernelException.class, () -> delegate.flip(FlippableIndexProxyTest.noOp(), FlippableIndexProxyTest.singleFailedDelegate(failed)));
    }

    @Test
    void shouldBlockAccessDuringFlipAndThenDelegateToCorrectContext() throws Exception {
        IndexProxy contextBeforeFlip = SchemaIndexTestHelper.mockIndexProxy();
        IndexProxy contextAfterFlip = SchemaIndexTestHelper.mockIndexProxy();
        FlippableIndexProxy flippable = new FlippableIndexProxy(contextBeforeFlip);
        flippable.setFlipTarget(FlippableIndexProxyTest.singleProxy(contextAfterFlip));
        CountDownLatch triggerFinishFlip = new CountDownLatch(1);
        CountDownLatch triggerExternalAccess = new CountDownLatch(1);
        try (OtherThreadExecutor flippingThread = new OtherThreadExecutor("Flipping thread", null);
             OtherThreadExecutor dropIndexThread = new OtherThreadExecutor("Drop index thread", null);){
            Future flipContextFuture = flippingThread.executeDontWait(FlippableIndexProxyTest.startFlipAndWaitForLatchBeforeFinishing(flippable, triggerFinishFlip, triggerExternalAccess));
            Assertions.assertTrue((boolean)triggerExternalAccess.await(10L, TimeUnit.SECONDS));
            Future dropIndexFuture = dropIndexThread.executeDontWait(FlippableIndexProxyTest.dropTheIndex(flippable));
            dropIndexThread.waitUntilWaiting();
            triggerFinishFlip.countDown();
            dropIndexFuture.get(10L, TimeUnit.SECONDS);
            flipContextFuture.get(10L, TimeUnit.SECONDS);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{contextBeforeFlip});
            ((IndexProxy)Mockito.verify((Object)contextAfterFlip)).drop();
        }
    }

    @Test
    void shouldAbortStoreScanWaitOnDrop() throws Exception {
        FakePopulatingIndexProxy delegate = new FakePopulatingIndexProxy();
        FlippableIndexProxy flipper = new FlippableIndexProxy((IndexProxy)delegate);
        try (OtherThreadExecutor waiter = new OtherThreadExecutor("Waiter", null);){
            Future waiting = waiter.executeDontWait(state -> flipper.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS));
            while (!delegate.awaitCalled) {
                Thread.sleep(10L);
            }
            flipper.drop();
            waiting.get(10L, TimeUnit.SECONDS);
        }
    }

    private static OtherThreadExecutor.WorkerCommand<Void, Void> dropTheIndex(FlippableIndexProxy flippable) {
        return state -> {
            flippable.drop();
            return null;
        };
    }

    private static OtherThreadExecutor.WorkerCommand<Void, Void> startFlipAndWaitForLatchBeforeFinishing(FlippableIndexProxy flippable, CountDownLatch triggerFinishFlip, CountDownLatch triggerExternalAccess) {
        return state -> {
            flippable.flip(() -> {
                triggerExternalAccess.countDown();
                Assertions.assertTrue((boolean)SchemaIndexTestHelper.awaitLatch(triggerFinishFlip));
                return Boolean.TRUE;
            }, null);
            return null;
        };
    }

    private static Callable<Boolean> noOp() {
        return () -> Boolean.TRUE;
    }

    private static IndexProxyFactory singleProxy(IndexProxy proxy) {
        return () -> proxy;
    }

    private static FailedIndexProxyFactory singleFailedDelegate(IndexProxy failed) {
        return failure -> failed;
    }

    private static class FakePopulatingIndexProxy
    extends IndexProxyAdapter {
        private volatile boolean awaitCalled;

        private FakePopulatingIndexProxy() {
        }

        @Override
        public boolean awaitStoreScanCompleted(long time, TimeUnit unit) {
            this.awaitCalled = true;
            return true;
        }
    }
}

