/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.test.scheduler.CallingThreadJobScheduler;
import org.neo4j.test.scheduler.JobSchedulerAdapter;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.Values;

public class BatchingMultipleIndexPopulatorTest {
    public static final int propertyId = 1;
    public static final int labelId = 1;
    private final IndexDescriptor index1 = TestIndexDescriptorFactory.forLabel(1, 1);
    private final IndexDescriptor index42 = TestIndexDescriptorFactory.forLabel(42, 42);
    private final InMemoryTokens tokens = new InMemoryTokens();

    @AfterEach
    void tearDown() {
        BatchingMultipleIndexPopulatorTest.clearProperty("queue_threshold");
        BatchingMultipleIndexPopulatorTest.clearProperty("await_timeout_minutes");
        BatchingMultipleIndexPopulatorTest.clearProperty("batch_size");
    }

    @Test
    void populateFromQueueDoesNothingIfThresholdNotReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 5);
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator((IndexStoreView)Mockito.mock(IndexStoreView.class), (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)updater);
        IndexEntryUpdate update1 = IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.index1.schema(), (Object[])new Object[]{"foo"});
        IndexEntryUpdate update2 = IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.index1.schema(), (Object[])new Object[]{"bar"});
        batchingPopulator.queueConcurrentUpdate(update1);
        batchingPopulator.queueConcurrentUpdate(update2);
        batchingPopulator.applyConcurrentUpdateQueueBatched(42L);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process((IndexEntryUpdate)ArgumentMatchers.any());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (PageCursorTracer)ArgumentMatchers.any());
    }

    @Test
    void populateFromQueuePopulatesWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("queue_threshold", 2);
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, () -> (StorageReader)Mockito.mock(StorageReader.class));
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator((IndexStoreView)storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator1.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)updater1);
        IndexPopulator populator2 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index42);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)populator2.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)updater2);
        batchingPopulator.createStoreScan(PageCursorTracer.NULL);
        IndexEntryUpdate update1 = IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.index1.schema(), (Object[])new Object[]{"foo"});
        IndexEntryUpdate update2 = IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.index42.schema(), (Object[])new Object[]{"bar"});
        IndexEntryUpdate update3 = IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.index1.schema(), (Object[])new Object[]{"baz"});
        batchingPopulator.queueConcurrentUpdate(update1);
        batchingPopulator.queueConcurrentUpdate(update2);
        batchingPopulator.queueConcurrentUpdate(update3);
        batchingPopulator.applyConcurrentUpdateQueueBatched(42L);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater1)).process(update3);
        ((IndexUpdater)Mockito.verify((Object)updater2)).process(update2);
    }

    @Test
    void pendingBatchesFlushedAfterStoreScan() throws Exception {
        EntityUpdates update1 = this.nodeUpdates(1, 1, "foo", 1L);
        EntityUpdates update2 = this.nodeUpdates(2, 1, "bar", 1L);
        EntityUpdates update3 = this.nodeUpdates(3, 1, "baz", 1L);
        EntityUpdates update42 = this.nodeUpdates(4, 42, "42", 42L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update42);
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexPopulator populator1 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        IndexPopulator populator42 = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index42);
        batchingPopulator.createStoreScan(PageCursorTracer.NULL).run();
        ((IndexPopulator)Mockito.verify((Object)populator1)).add(this.forUpdates(this.index1, update1, update2, update3), PageCursorTracer.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator42)).add(this.forUpdates(this.index42, update42), PageCursorTracer.NULL);
    }

    @Test
    void batchIsFlushedWhenThresholdReached() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates update1 = this.nodeUpdates(1, 1, "foo", 1L);
        EntityUpdates update2 = this.nodeUpdates(2, 1, "bar", 1L);
        EntityUpdates update3 = this.nodeUpdates(3, 1, "baz", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3);
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        batchingPopulator.createStoreScan(PageCursorTracer.NULL).run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update1, update2), PageCursorTracer.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update3), PageCursorTracer.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void populatorMarkedAsFailed() throws Exception {
        IndexPopulator populator;
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates update1 = this.nodeUpdates(1, 1, "aaa", 1L);
        EntityUpdates update2 = this.nodeUpdates(1, 1, "bbb", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler(executor);
        try {
            MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)jobScheduler, (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
            List<IndexEntryUpdate<IndexDescriptor>> expected = this.forUpdates(this.index1, update1, update2);
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{batchFlushError}).when((Object)populator)).add(expected, PageCursorTracer.NULL);
            batchingPopulator.createStoreScan(PageCursorTracer.NULL).run();
        }
        finally {
            jobScheduler.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
    }

    @Test
    void populatorMarkedAsFailedAndUpdatesNotAdded() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates update1 = this.nodeUpdates(1, 1, "aaa", 1L);
        EntityUpdates update2 = this.nodeUpdates(1, 1, "bbb", 1L);
        EntityUpdates update3 = this.nodeUpdates(1, 1, "ccc", 1L);
        EntityUpdates update4 = this.nodeUpdates(1, 1, "ddd", 1L);
        EntityUpdates update5 = this.nodeUpdates(1, 1, "eee", 1L);
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(update1, update2, update3, update4, update5);
        RuntimeException batchFlushError = new RuntimeException("Batch failed");
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)new CallingThreadJobScheduler(), (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexPopulator populator = BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{batchFlushError}).when((Object)populator)).add(this.forUpdates(this.index1, update3, update4), PageCursorTracer.NULL);
        batchingPopulator.createStoreScan(PageCursorTracer.NULL).run();
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update1, update2), PageCursorTracer.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator)).add(this.forUpdates(this.index1, update3, update4), PageCursorTracer.NULL);
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(IndexPopulationFailure.failure((Throwable)batchFlushError).asString());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).add(this.forUpdates(this.index1, update5), PageCursorTracer.NULL);
    }

    @Test
    void shouldApplyBatchesInParallel() throws Exception {
        BatchingMultipleIndexPopulatorTest.setProperty("batch_size", 2);
        EntityUpdates[] updates = new EntityUpdates[9];
        for (int i = 0; i < updates.length; ++i) {
            updates[i] = this.nodeUpdates(i, 1, String.valueOf(i), 1L);
        }
        IndexStoreView storeView = BatchingMultipleIndexPopulatorTest.newStoreView(updates);
        final AtomicInteger scheduleCount = new AtomicInteger();
        JobSchedulerAdapter jobScheduler = new JobSchedulerAdapter(){

            public JobHandle<?> schedule(Group group, Runnable job) {
                scheduleCount.incrementAndGet();
                job.run();
                return super.schedule(group, job);
            }
        };
        MultipleIndexPopulator batchingPopulator = new MultipleIndexPopulator(storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, (SchemaState)Mockito.mock(SchemaState.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (JobScheduler)jobScheduler, (TokenNameLookup)this.tokens, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        BatchingMultipleIndexPopulatorTest.addPopulator(batchingPopulator, this.index1);
        batchingPopulator.createStoreScan(PageCursorTracer.NULL).run();
        AssertionsForInterfaceTypes.assertThat((int)scheduleCount.get()).isGreaterThanOrEqualTo(5);
    }

    private List<IndexEntryUpdate<IndexDescriptor>> forUpdates(IndexDescriptor index, EntityUpdates ... updates) {
        return Iterables.asList((Iterable)Iterables.concat((Iterable)Iterables.map(update -> update.forIndexKeys(Iterables.asIterable((Object[])new IndexDescriptor[]{index})), Arrays.asList(updates))));
    }

    private EntityUpdates nodeUpdates(int nodeId, int propertyId, String propertyValue, long ... labelIds) {
        return EntityUpdates.forEntity((long)nodeId, (boolean)false).withTokens(labelIds).withTokensAfter(labelIds).added(propertyId, Values.of((Object)propertyValue)).build();
    }

    private static IndexPopulator addPopulator(MultipleIndexPopulator batchingPopulator, IndexDescriptor descriptor) {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        batchingPopulator.addPopulator(populator, descriptor, flipper, failedIndexProxyFactory, "testIndex");
        return populator;
    }

    private static IndexStoreView newStoreView(EntityUpdates ... updates) {
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (PageCursorTracer)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Visitor visitorArg = (Visitor)invocation.getArgument(2);
            return new IndexEntryUpdateScan(updates, (Visitor<EntityUpdates, IndexPopulationFailedKernelException>)visitorArg);
        });
        Mockito.when((Object)storeView.newPropertyAccessor((PageCursorTracer)ArgumentMatchers.any(PageCursorTracer.class), (MemoryTracker)ArgumentMatchers.any())).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
        return storeView;
    }

    private static void setProperty(String name, int value) {
        FeatureToggles.set(MultipleIndexPopulator.class, (String)name, (Object)value);
    }

    private static void clearProperty(String name) {
        FeatureToggles.clear(MultipleIndexPopulator.class, (String)name);
    }

    private static class IndexEntryUpdateScan
    implements StoreScan<IndexPopulationFailedKernelException> {
        final EntityUpdates[] updates;
        final Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor;
        boolean stop;

        IndexEntryUpdateScan(EntityUpdates[] updates, Visitor<EntityUpdates, IndexPopulationFailedKernelException> visitor) {
            this.updates = updates;
            this.visitor = visitor;
        }

        public void run() throws IndexPopulationFailedKernelException {
            for (EntityUpdates update : this.updates) {
                if (this.stop) {
                    return;
                }
                this.visitor.visit((Object)update);
            }
        }

        public void stop() {
            this.stop = true;
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.NONE;
        }
    }
}

