/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSetsImpl;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class MutableDiffSetsImplTest {
    private static final Predicate<Long> ODD_FILTER = item -> item % 2L != 0L;
    private final MutableDiffSets<Long> diffSets = MutableDiffSetsImpl.newMutableDiffSets((MemoryTracker)EmptyMemoryTracker.INSTANCE);

    MutableDiffSetsImplTest() {
    }

    @Test
    void testAdd() {
        this.diffSets.add((Object)1L);
        this.diffSets.add((Object)2L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)this.diffSets.getAdded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.getRemoved().isEmpty());
    }

    @Test
    void testRemove() {
        this.diffSets.add((Object)1L);
        this.diffSets.remove((Object)2L);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)this.diffSets.getAdded());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)this.diffSets.getRemoved());
    }

    @Test
    void testAddRemove() {
        this.diffSets.add((Object)1L);
        this.diffSets.remove((Object)1L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.getAdded().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.getRemoved().isEmpty());
    }

    @Test
    void testRemoveAdd() {
        this.diffSets.remove((Object)1L);
        this.diffSets.add((Object)1L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.getAdded().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.getRemoved().isEmpty());
    }

    @Test
    void testIsAddedOrRemoved() {
        this.diffSets.add((Object)1L);
        this.diffSets.remove((Object)10L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.isAdded((Object)1L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.diffSets.isAdded((Object)2L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.diffSets.isRemoved((Object)10L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.diffSets.isRemoved((Object)2L));
    }

    @Test
    void testReturnSourceFromApplyWithEmptyDiffSets() {
        Iterator result = this.diffSets.apply(Collections.singletonList(18L).iterator());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(18L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    void testAppendAddedToSourceInApply() {
        this.diffSets.add((Object)52L);
        this.diffSets.remove((Object)43L);
        Iterator result = this.diffSets.apply(Collections.singletonList(18L).iterator());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(18L, 52L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    void testFilterRemovedFromSourceInApply() {
        this.diffSets.remove((Object)43L);
        Iterator result = this.diffSets.apply(Arrays.asList(42L, 43L, 44L).iterator());
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(42L, 44L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    void testFilterAddedFromSourceInApply() {
        this.diffSets.add((Object)42L);
        this.diffSets.add((Object)44L);
        Iterator result = this.diffSets.apply(Arrays.asList(42L, 43L).iterator());
        Collection collectedResult = Iterators.asCollection((Iterator)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)collectedResult.size());
        Assertions.assertThat((Iterable)collectedResult).contains((Object[])new Long[]{43L, 42L, 44L});
    }
}

