/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

class KernelTransactionImplementationHandleTest {
    private final SystemNanoClock clock = Clocks.nanoClock();

    KernelTransactionImplementationHandleTest() {
    }

    @Test
    void returnsCorrectLastTransactionTimestampWhenStarted() {
        long lastCommittedTxTimestamp = 42L;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.lastTransactionTimestampWhenStarted()).thenReturn((Object)lastCommittedTxTimestamp);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertEquals((long)lastCommittedTxTimestamp, (long)handle.lastTransactionTimestampWhenStarted());
    }

    @Test
    void returnsCorrectLastTransactionTimestampWhenStartedForClosedTx() {
        long lastCommittedTxTimestamp = 4242L;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.lastTransactionTimestampWhenStarted()).thenReturn((Object)lastCommittedTxTimestamp);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)false);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertEquals((long)lastCommittedTxTimestamp, (long)handle.lastTransactionTimestampWhenStarted());
    }

    @Test
    void isOpenForUnchangedKernelTransactionImplementation() {
        int reuseCount = 42;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)reuseCount);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertTrue((boolean)handle.isOpen());
    }

    @Test
    void isOpenForReusedKernelTransactionImplementation() {
        int initialReuseCount = 42;
        int nextReuseCount = 4242;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)initialReuseCount).thenReturn((Object)nextReuseCount);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertFalse((boolean)handle.isOpen());
    }

    @Test
    void markForTerminationCallsKernelTransactionImplementation() {
        int reuseCount = 42;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)reuseCount);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        handle.markForTermination((Status)terminationReason);
        ((KernelTransactionImplementation)Mockito.verify((Object)tx)).markForTermination((long)reuseCount, (Status)terminationReason);
    }

    @Test
    void markForTerminationReturnsTrueWhenSuccessful() {
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)42);
        Mockito.when((Object)tx.markForTermination(ArgumentMatchers.anyLong(), (Status)ArgumentMatchers.any())).thenReturn((Object)true);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertTrue((boolean)handle.markForTermination((Status)Status.Transaction.Terminated));
    }

    @Test
    void markForTerminationReturnsFalseWhenNotSuccessful() {
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)42);
        Mockito.when((Object)tx.markForTermination(ArgumentMatchers.anyLong(), (Status)ArgumentMatchers.any())).thenReturn((Object)false);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertFalse((boolean)handle.markForTermination((Status)Status.Transaction.Terminated));
    }

    @Test
    void transactionStatisticForReusedTransactionIsNotAvailable() {
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)2).thenReturn((Object)3);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx, this.clock);
        Assertions.assertSame((Object)TransactionExecutionStatistic.NOT_AVAILABLE, (Object)handle.transactionStatistic());
    }
}

