/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;

public class TestIndexDescriptorFactory {
    private TestIndexDescriptorFactory() {
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema) {
        int id = TestIndexDescriptorFactory.randomId();
        return IndexPrototype.forSchema((SchemaDescriptor)schema).withName("index_" + id).materialise((long)id);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema) {
        int id = TestIndexDescriptorFactory.randomId();
        return IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("index_" + id).materialise((long)id);
    }

    public static IndexDescriptor forLabel(int labelId, int ... propertyIds) {
        return TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyIds));
    }

    public static IndexDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return TestIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyIds));
    }

    private static int randomId() {
        return ThreadLocalRandom.current().nextInt(1, 1000);
    }
}

