/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.query.SimpleState;
import org.neo4j.kernel.api.query.WaitingOnLock;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.WaitStrategy;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

class ExecutingQueryStatusTest {
    private static final FakeClock clock = Clocks.fakeClock((TemporalAccessor)ZonedDateTime.parse("2016-12-16T16:14:12+01:00"));

    ExecutingQueryStatusTest() {
    }

    @Test
    void shouldProduceSensibleMapRepresentationInRunningState() {
        String status = SimpleState.running().name();
        Assertions.assertEquals((Object)"running", (Object)status);
    }

    @Test
    void shouldProduceSensibleMapRepresentationInPlanningState() {
        String status = SimpleState.planning().name();
        Assertions.assertEquals((Object)"planning", (Object)status);
    }

    @Test
    void shouldProduceSensibleMapRepresentationInPlannedState() {
        String status = SimpleState.planned().name();
        Assertions.assertEquals((Object)"planned", (Object)status);
    }

    @Test
    void shouldProduceSensibleMapRepresentationInParsingState() {
        String status = SimpleState.parsing().name();
        Assertions.assertEquals((Object)"parsing", (Object)status);
    }

    @Test
    void shouldProduceSensibleMapRepresentationInWaitingOnLockState() {
        long[] resourceIds = new long[]{17L};
        WaitingOnLock status = new WaitingOnLock("EXCLUSIVE", ExecutingQueryStatusTest.resourceType("NODE"), resourceIds, clock.nanos());
        clock.forward(17L, TimeUnit.MILLISECONDS);
        Map statusMap = status.toMap(clock.nanos());
        Assertions.assertEquals((Object)"waiting", (Object)status.name());
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("waitTimeMillis", 17L);
        expected.put("lockMode", "EXCLUSIVE");
        expected.put("resourceType", "NODE");
        expected.put("resourceIds", resourceIds);
        Assertions.assertEquals(expected, (Object)statusMap);
    }

    private static ResourceType resourceType(final String name) {
        return new ResourceType(){

            public String toString() {
                return this.name();
            }

            public int typeId() {
                throw new UnsupportedOperationException("not used");
            }

            public WaitStrategy waitStrategy() {
                throw new UnsupportedOperationException("not used");
            }

            public String name() {
                return name;
            }
        };
    }
}

