/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class ValueUtilsTest {
    ValueUtilsTest() {
    }

    @Test
    void shouldHandleCollection() {
        List<Integer> collection = Arrays.asList(1, 2, 3);
        AnyValue of = ValueUtils.of(collection);
        Assertions.assertThat((Object)of).isInstanceOf(ListValue.class);
        ListValue listValue = (ListValue)of;
        Assertions.assertThat((Object)listValue.value(0)).isEqualTo((Object)Values.intValue((int)1));
        Assertions.assertThat((Object)listValue.value(1)).isEqualTo((Object)Values.intValue((int)2));
        Assertions.assertThat((Object)listValue.value(2)).isEqualTo((Object)Values.intValue((int)3));
        Assertions.assertThat((int)listValue.size()).isEqualTo(3);
    }

    @Test
    void shouldHandleIterator() {
        Iterator<Integer> iterator = Arrays.asList(1, 2, 3).iterator();
        AnyValue of = ValueUtils.of(iterator);
        Assertions.assertThat((Object)of).isInstanceOf(ListValue.class);
        ListValue listValue = (ListValue)of;
        Assertions.assertThat((Object)listValue.value(0)).isEqualTo((Object)Values.intValue((int)1));
        Assertions.assertThat((Object)listValue.value(1)).isEqualTo((Object)Values.intValue((int)2));
        Assertions.assertThat((Object)listValue.value(2)).isEqualTo((Object)Values.intValue((int)3));
        Assertions.assertThat((int)listValue.size()).isEqualTo(3);
    }

    @Test
    void shouldHandleMaps() {
        Map map = MapUtil.map((Object[])new Object[]{"a", Arrays.asList("foo", 42)});
        AnyValue anyValue = ValueUtils.of((Object)map);
        Assertions.assertThat((Object)anyValue).isInstanceOf(MapValue.class);
        MapValue mapValue = (MapValue)anyValue;
        Assertions.assertThat((Object)mapValue.get("a")).isEqualTo((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"foo"), Values.intValue((int)42)}));
        Assertions.assertThat((int)mapValue.size()).isEqualTo(1);
    }

    @Test
    void shouldHandleIterable() {
        List<Integer> collection = Arrays.asList(1, 2, 3);
        AnyValue of = ValueUtils.of(collection);
        Assertions.assertThat((Object)of).isInstanceOf(ListValue.class);
        ListValue listValue = (ListValue)of;
        Assertions.assertThat((Object)listValue.value(0)).isEqualTo((Object)Values.intValue((int)1));
        Assertions.assertThat((Object)listValue.value(1)).isEqualTo((Object)Values.intValue((int)2));
        Assertions.assertThat((Object)listValue.value(2)).isEqualTo((Object)Values.intValue((int)3));
        Assertions.assertThat((int)listValue.size()).isEqualTo(3);
    }
}

