/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Format;

class TestFormat {
    TestFormat() {
    }

    @Test
    void dateTime() throws Exception {
        long timeWithDate = System.currentTimeMillis();
        String dateAsString = Format.date((long)timeWithDate);
        Assertions.assertEquals((long)timeWithDate, (long)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").parse(dateAsString).getTime());
        String timeAsString = Format.time((long)timeWithDate);
        Assertions.assertEquals((long)timeWithDate, (long)TestFormat.translateToDate(timeWithDate, new SimpleDateFormat("HH:mm:ss.SSS").parse(timeAsString).getTime(), Format.DEFAULT_TIME_ZONE));
    }

    @Test
    void dateTimeWithTimeZone() throws Exception {
        String zoneOffset = "+03:00";
        TimeZone zone = TimeZone.getTimeZone("GMT" + zoneOffset);
        String asString = Format.date((TimeZone)zone);
        Assertions.assertTrue((boolean)asString.endsWith(TestFormat.withoutColon(zoneOffset)));
        long timeWithDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").parse(asString).getTime();
        asString = Format.date((long)timeWithDate, (TimeZone)zone);
        Assertions.assertTrue((boolean)asString.endsWith(TestFormat.withoutColon(zoneOffset)));
        Assertions.assertEquals((long)timeWithDate, (long)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").parse(asString).getTime());
        asString = Format.date((Date)new Date(timeWithDate), (TimeZone)zone);
        Assertions.assertTrue((boolean)asString.endsWith(TestFormat.withoutColon(zoneOffset)));
        Assertions.assertEquals((long)timeWithDate, (long)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ").parse(asString).getTime());
        asString = Format.time((long)timeWithDate, (TimeZone)zone);
        Assertions.assertEquals((long)timeWithDate, (long)TestFormat.translateToDate(timeWithDate, new SimpleDateFormat("HH:mm:ss.SSS").parse(asString).getTime(), zone));
        asString = Format.time((Date)new Date(timeWithDate), (TimeZone)zone);
        Assertions.assertEquals((long)timeWithDate, (long)TestFormat.translateToDate(timeWithDate, new SimpleDateFormat("HH:mm:ss.SSS").parse(asString).getTime(), zone));
    }

    private static long translateToDate(long timeWithDate, long time, TimeZone timeIsGivenInThisTimeZone) {
        Calendar calendar = Calendar.getInstance(timeIsGivenInThisTimeZone);
        calendar.setTimeInMillis(timeWithDate);
        Calendar timeCalendar = Calendar.getInstance();
        timeCalendar.setTimeInMillis(time);
        timeCalendar.setTimeZone(timeIsGivenInThisTimeZone);
        timeCalendar.set(1, calendar.get(1));
        timeCalendar.set(2, calendar.get(2));
        boolean crossedDayBoundary = !timeIsGivenInThisTimeZone.equals(Format.DEFAULT_TIME_ZONE) && timeCalendar.get(11) < calendar.get(11);
        timeCalendar.set(5, calendar.get(5) + (crossedDayBoundary ? 1 : 0));
        return timeCalendar.getTimeInMillis();
    }

    private static String withoutColon(String zoneOffset) {
        return zoneOffset.replaceAll(":", "");
    }
}

