/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Exceptions;

class ExceptionsTest {
    ExceptionsTest() {
    }

    @Test
    void shouldDetectContainsOneOfSome() {
        ARuntimeException cause = new ARuntimeException(new AnotherRuntimeException(new NullPointerException("Some words")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Exceptions.contains((Throwable)cause, (String)"words", (Class[])new Class[]{NullPointerException.class}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Exceptions.contains((Throwable)cause, (String)"not", (Class[])new Class[]{NullPointerException.class}));
    }

    @Test
    void shouldSetMessage() {
        String initialMessage = "Initial message";
        LevelOneException exception = new LevelOneException(initialMessage);
        String prependedMessage = "Prepend this: " + exception.getMessage();
        Exceptions.withMessage((Throwable)exception, (String)prependedMessage);
        org.junit.jupiter.api.Assertions.assertEquals((Object)prependedMessage, (Object)exception.getMessage());
    }

    @Test
    void shouldChainExceptionsWhenInitialExceptionIsNull() {
        RuntimeException exception = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain(null, (Throwable)exception);
        org.junit.jupiter.api.Assertions.assertSame((Object)exception, (Object)chainedException);
    }

    @Test
    void shouldChainExceptionsWhenCurrentExceptionIsNull() {
        RuntimeException exception = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain((Throwable)exception, null);
        org.junit.jupiter.api.Assertions.assertSame((Object)exception, (Object)chainedException);
        Assertions.assertThat((Object[])chainedException.getSuppressed()).isEmpty();
    }

    @Test
    void shouldChainExceptions() {
        RuntimeException exception1 = new RuntimeException();
        RuntimeException exception2 = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain((Throwable)exception1, (Throwable)exception2);
        org.junit.jupiter.api.Assertions.assertSame((Object)exception1, (Object)chainedException);
        Assertions.assertThat((Object[])chainedException.getSuppressed()).containsExactly((Object[])new Throwable[]{exception2});
    }

    @Test
    void shouldNotChainSameException() {
        RuntimeException exception = new RuntimeException();
        RuntimeException chainedException = (RuntimeException)Exceptions.chain((Throwable)exception, (Throwable)exception);
        org.junit.jupiter.api.Assertions.assertSame((Object)exception, (Object)chainedException);
        Assertions.assertThat((Object[])chainedException.getSuppressed()).isEmpty();
    }

    private static class AnotherRuntimeException
    extends RuntimeException {
        AnotherRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class ARuntimeException
    extends RuntimeException {
        ARuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class LevelOneException
    extends Exception {
        LevelOneException(String message) {
            super(message);
        }
    }
}

