/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingArrayListTest {
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private HeapTrackingArrayList<Object> aList;
    private Object[] objArray;

    HeapTrackingArrayListTest() {
    }

    @BeforeEach
    void setUp() {
        this.objArray = new Object[100];
        for (int i = 0; i < this.objArray.length; ++i) {
            this.objArray[i] = i;
        }
        this.aList = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
        this.aList.addAll(Arrays.asList(this.objArray));
    }

    @AfterEach
    void tearDown() {
        this.objArray = null;
        this.aList.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void initialSize() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((int)5, (MemoryTracker)this.memoryTracker);){
            Assertions.assertEquals((int)0, (int)list.size(), (String)"Should not contain any elements when created");
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> HeapTrackingArrayList.newArrayList((int)-10, (MemoryTracker)this.memoryTracker));
    }

    @Test
    void addObjectAtIndex() {
        Object o = new Object();
        this.aList.add(50, o);
        Assertions.assertSame((Object)this.aList.get(50), (Object)o, (String)"Failed to add Object");
        Assertions.assertTrue((this.aList.get(51) == this.objArray[50] && this.aList.get(52) == this.objArray[51] ? 1 : 0) != 0, (String)"Failed to fix up list after insert");
        Object oldItem = this.aList.get(25);
        this.aList.add(25, null);
        Assertions.assertNull((Object)this.aList.get(25), (String)"Should have returned null");
        Assertions.assertSame((Object)this.aList.get(26), (Object)oldItem, (String)"Should have returned the old item from slot 25");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.add(-1, null));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.add(this.aList.size() + 1, null));
    }

    @Test
    void addObjectLast() {
        Object o = new Object();
        this.aList.add(o);
        Assertions.assertSame((Object)this.aList.get(this.aList.size() - 1), (Object)o, (String)"Failed to add Object");
        this.aList.add(null);
        Assertions.assertNull((Object)this.aList.get(this.aList.size() - 1), (String)"Failed to add null");
    }

    @Test
    void addAllFromCollectionAtIndex() {
        int i;
        this.aList.addAll(50, this.aList);
        Assertions.assertEquals((int)200, (int)this.aList.size(), (String)"Returned incorrect size after adding to existing list");
        for (i = 0; i < 50; ++i) {
            Assertions.assertSame((Object)this.aList.get(i), (Object)this.objArray[i], (String)"Manipulated elements < index");
        }
        for (i = 50; i < 150; ++i) {
            Assertions.assertSame((Object)this.aList.get(i), (Object)this.objArray[i - 50], (String)"Failed to add elements properly");
        }
        for (i = 150; i < 200; ++i) {
            Assertions.assertSame((Object)this.aList.get(i), (Object)this.objArray[i - 100], (String)"Failed to ad elements properly");
        }
        try (HeapTrackingArrayList listWithNulls = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            listWithNulls.add(null);
            listWithNulls.add(null);
            listWithNulls.add((Object)"yoink");
            listWithNulls.add((Object)"kazoo");
            listWithNulls.add(null);
            this.aList.addAll(100, (Collection)listWithNulls);
            Assertions.assertEquals((int)205, (int)this.aList.size(), (String)("Incorrect size: " + this.aList.size()));
            Assertions.assertNull((Object)this.aList.get(100), (String)"Item at slot 100 should be null");
            Assertions.assertNull((Object)this.aList.get(101), (String)"Item at slot 101 should be null");
            Assertions.assertEquals((Object)"yoink", (Object)this.aList.get(102), (String)"Item at slot 102 should be 'yoink'");
            Assertions.assertEquals((Object)"kazoo", (Object)this.aList.get(103), (String)"Item at slot 103 should be 'kazoo'");
            Assertions.assertNull((Object)this.aList.get(104), (String)"Item at slot 104 should be null");
            this.aList.addAll(205, (Collection)listWithNulls);
            Assertions.assertEquals((int)210, (int)this.aList.size(), (String)("Incorrect size2: " + this.aList.size()));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.addAll(-1, (Collection)listWithNulls));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.addAll(this.aList.size() + 1, (Collection)listWithNulls));
            Assertions.assertThrows(NullPointerException.class, () -> this.aList.addAll(0, null));
        }
    }

    @Test
    void addAllFromCollection() {
        try (HeapTrackingArrayList l = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            int i;
            l.addAll(this.aList);
            for (i = 0; i < this.aList.size(); ++i) {
                Assertions.assertEquals((Object)l.get(i), (Object)this.aList.get(i), (String)"Failed to add elements properly");
            }
            this.aList.addAll(this.aList);
            Assertions.assertEquals((int)200, (int)this.aList.size(), (String)"Returned incorrect size after adding to existing list");
            for (i = 0; i < 100; ++i) {
                Assertions.assertEquals((Object)this.aList.get(i), (Object)l.get(i), (String)"Added to list in incorrect order");
                Assertions.assertEquals((Object)this.aList.get(i + 100), (Object)l.get(i), (String)"Failed to add to existing list");
            }
        }
        HashSet<String> setWithNulls = new HashSet<String>();
        setWithNulls.add(null);
        setWithNulls.add(null);
        setWithNulls.add("yoink");
        setWithNulls.add("kazoo");
        setWithNulls.add(null);
        this.aList.addAll(100, setWithNulls);
        Iterator i = setWithNulls.iterator();
        Assertions.assertSame((Object)this.aList.get(100), i.next(), (String)("Item at slot 100 is wrong: " + this.aList.get(100)));
        Assertions.assertSame((Object)this.aList.get(101), i.next(), (String)("Item at slot 101 is wrong: " + this.aList.get(101)));
        Assertions.assertSame((Object)this.aList.get(102), i.next(), (String)("Item at slot 103 is wrong: " + this.aList.get(102)));
        try (HeapTrackingArrayList originalList = HeapTrackingArrayList.newArrayList((int)12, (MemoryTracker)this.memoryTracker);){
            for (int j = 0; j < 12; ++j) {
                originalList.add((Object)j);
            }
            originalList.remove(0);
            originalList.remove(0);
            try (HeapTrackingArrayList additionalList = HeapTrackingArrayList.newArrayList((int)11, (MemoryTracker)this.memoryTracker);){
                for (int j = 0; j < 11; ++j) {
                    additionalList.add((Object)j);
                }
                Assertions.assertTrue((boolean)originalList.addAll((Collection)additionalList));
            }
            Assertions.assertEquals((int)21, (int)originalList.size());
        }
        Assertions.assertThrows(NullPointerException.class, () -> this.aList.addAll(null));
    }

    @Test
    void clear() {
        this.aList.clear();
        Assertions.assertEquals((int)0, (int)this.aList.size(), (String)"List did not clear");
        this.aList.add(null);
        this.aList.add(null);
        this.aList.add(null);
        this.aList.add((Object)"bam");
        this.aList.clear();
        Assertions.assertEquals((int)0, (int)this.aList.size(), (String)"List with nulls did not clear");
    }

    @Test
    void contains() {
        Assertions.assertTrue((boolean)this.aList.contains(this.objArray[99]), (String)"Returned false for valid element");
        Assertions.assertTrue((boolean)this.aList.contains((Object)8), (String)"Returned false for equal element");
        Assertions.assertFalse((boolean)this.aList.contains(new Object()), (String)"Returned true for invalid element");
        Assertions.assertFalse((boolean)this.aList.contains(null), (String)"Returned true for null but should have returned false");
        this.aList.add(null);
        Assertions.assertTrue((boolean)this.aList.contains(null), (String)"Returned false for null but should have returned true");
    }

    @Test
    void get() {
        Assertions.assertSame((Object)this.aList.get(22), (Object)this.objArray[22], (String)"Returned incorrect element");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.get(8765));
    }

    @Test
    void indexOfElement() {
        Assertions.assertEquals((int)87, (int)this.aList.indexOf(this.objArray[87]), (String)"Returned incorrect index");
        Assertions.assertEquals((int)-1, (int)this.aList.indexOf(new Object()), (String)"Returned index for invalid Object");
        this.aList.add(25, null);
        this.aList.add(50, null);
        Assertions.assertEquals((int)25, (int)this.aList.indexOf(null), (String)("Wrong indexOf for null.  Wanted 25 got: " + this.aList.indexOf(null)));
    }

    @Test
    void isEmpty() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            Assertions.assertTrue((boolean)list.isEmpty(), (String)"isEmpty returned false for new list");
        }
        Assertions.assertFalse((boolean)this.aList.isEmpty(), (String)"Returned true for existing list with elements");
    }

    @Test
    void lastIndexOfElement() {
        this.aList.add((Object)99);
        Assertions.assertEquals((int)100, (int)this.aList.lastIndexOf(this.objArray[99]), (String)"Returned incorrect index");
        Assertions.assertEquals((int)-1, (int)this.aList.lastIndexOf(new Object()), (String)"Returned index for invalid Object");
        this.aList.add(25, null);
        this.aList.add(50, null);
        Assertions.assertEquals((int)50, (int)this.aList.lastIndexOf(null), (String)("Wrong lastIndexOf for null.  Wanted 50 got: " + this.aList.lastIndexOf(null)));
    }

    @Test
    void removeIndex() {
        this.aList.remove(10);
        Assertions.assertEquals((int)-1, (int)this.aList.indexOf(this.objArray[10]), (String)"Failed to remove element");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.remove(999));
        Object[] objects = this.aList.toArray();
        this.aList.add(25, null);
        this.aList.add(50, null);
        this.aList.remove(50);
        this.aList.remove(25);
        Assertions.assertArrayEquals((Object[])objects, (Object[])this.aList.toArray(), (String)"Removing nulls did not work");
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            list.addAll(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
            Assertions.assertSame((Object)"a", (Object)list.remove(0), (String)"Removed wrong element 1");
            Assertions.assertSame((Object)"f", (Object)list.remove(4), (String)"Removed wrong element 2");
            Object[] result = new String[5];
            list.toArray(result);
            Assertions.assertArrayEquals((Object[])result, (Object[])new String[]{"b", "c", "d", "e", "g"}, (String)"Removed wrong element 3");
        }
        try (HeapTrackingArrayList l = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            l.add(new Object());
            l.add(new Object());
            l.remove(0);
            l.remove(0);
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> l.remove(-1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> l.remove(0));
        }
    }

    @Test
    void setElement() {
        Object obj = new Object();
        this.aList.set(65, obj);
        Assertions.assertSame((Object)this.aList.get(65), (Object)obj, (String)"Failed to set object");
        this.aList.set(50, null);
        Assertions.assertNull((Object)this.aList.get(50), (String)"Setting to null did not work");
        Assertions.assertEquals((int)100, (int)this.aList.size(), (String)("Setting increased the list's size to: " + this.aList.size()));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.set(-1, null));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.aList.set(this.aList.size() + 1, null));
    }

    @Test
    void size() {
        Assertions.assertEquals((int)100, (int)this.aList.size(), (String)"Returned incorrect size for exiting list");
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            Assertions.assertEquals((int)0, (int)list.size(), (String)"Returned incorrect size for new list");
        }
    }

    @Test
    void toArray() {
        this.aList.set(25, null);
        this.aList.set(75, null);
        Object[] obj = this.aList.toArray();
        Assertions.assertEquals((int)this.objArray.length, (int)obj.length, (String)"Returned array of incorrect size");
        for (int i = 0; i < obj.length; ++i) {
            if (i == 25 || i == 75) {
                Assertions.assertNull((Object)obj[i], (String)("Should be null at: " + i + " but instead got: " + obj[i]));
                continue;
            }
            Assertions.assertSame((Object)obj[i], (Object)this.objArray[i], (String)("Returned incorrect array: " + i));
        }
    }

    @Test
    void toArrayWithDestination() {
        this.aList.set(25, null);
        this.aList.set(75, null);
        Object[] argArray = new Integer[100];
        Object[] retArray = this.aList.toArray(argArray);
        Assertions.assertSame((Object)retArray, (Object)argArray, (String)"Returned different array than passed");
        argArray = new Integer[1000];
        retArray = this.aList.toArray(argArray);
        Assertions.assertNull((Object)argArray[this.aList.size()], (String)"Failed to set first extra element to null");
        for (int i = 0; i < 100; ++i) {
            if (i == 25 || i == 75) {
                Assertions.assertNull((Object)retArray[i], (String)("Should be null: " + i));
                continue;
            }
            Assertions.assertSame((Object)retArray[i], (Object)this.objArray[i], (String)("Returned incorrect array: " + i));
        }
        String[] strArray = new String[100];
        Assertions.assertThrows(ArrayStoreException.class, () -> this.aList.toArray((Object[])strArray));
    }

    @Test
    void addAll() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
             HeapTrackingArrayList collection = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            list.add((Object)"one");
            list.add((Object)"two");
            Assertions.assertEquals((int)2, (int)list.size());
            list.remove(0);
            Assertions.assertEquals((int)1, (int)list.size());
            collection.add((Object)"1");
            collection.add((Object)"2");
            collection.add((Object)"3");
            Assertions.assertEquals((int)3, (int)collection.size());
            list.addAll(0, (Collection)collection);
            Assertions.assertEquals((int)4, (int)list.size());
            list.remove(0);
            list.remove(0);
            Assertions.assertEquals((int)2, (int)list.size());
            collection.add((Object)"4");
            collection.add((Object)"5");
            collection.add((Object)"6");
            collection.add((Object)"7");
            collection.add((Object)"8");
            collection.add((Object)"9");
            collection.add((Object)"10");
            collection.add((Object)"11");
            collection.add((Object)"12");
            Assertions.assertEquals((int)12, (int)collection.size());
            list.addAll(0, (Collection)collection);
            Assertions.assertEquals((int)14, (int)list.size());
        }
    }

    @Test
    void removeElement() {
        Object[] result;
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            list.addAll(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
            Assertions.assertTrue((boolean)list.remove((Object)"a"), (String)"Removed wrong element 1");
            Assertions.assertTrue((boolean)list.remove((Object)"f"), (String)"Removed wrong element 2");
            result = new String[5];
            list.toArray(result);
            Assertions.assertArrayEquals((Object[])result, (Object[])new String[]{"b", "c", "d", "e", "g"}, (String)"Removed wrong element 3");
        }
        list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
        try {
            list.addAll(Arrays.asList("a", null, "c"));
            Assertions.assertFalse((boolean)list.remove((Object)"d"), (String)"Removed non-existing element");
            Assertions.assertTrue((boolean)list.remove(null), (String)"Removed wrong element 4");
            result = new String[2];
            list.toArray(result);
            Assertions.assertArrayEquals((Object[])result, (Object[])new String[]{"a", "c"}, (String)"Removed wrong element 5");
        }
        finally {
            if (list != null) {
                list.close();
            }
        }
    }

    @Test
    void containsAll() {
        Assertions.assertTrue((boolean)this.aList.containsAll(Arrays.asList(1, 3, 5, 7)));
        Assertions.assertFalse((boolean)this.aList.containsAll(Arrays.asList(1, 3, 5, 7, -1)));
    }

    @Test
    void removeAll() {
        Assertions.assertTrue((boolean)this.aList.removeAll(Arrays.asList(1, 3, 8, 9, 10)));
        Assertions.assertTrue((boolean)this.aList.removeAll(Arrays.asList(1, 3, 8, 9, 10, 11)));
        Assertions.assertFalse((boolean)this.aList.removeAll(Arrays.asList(1, 3, 8, 9, 10, 11)));
    }

    @Test
    void retainAll() {
        Assertions.assertTrue((boolean)this.aList.retainAll(Arrays.asList(1, 3, 5)));
        Assertions.assertArrayEquals((Object[])this.aList.toArray(), (Object[])new Object[]{1, 3, 5});
    }

    @Test
    void sort() {
        this.aList.add((Object)-1);
        Assertions.assertEquals((Object)0, (Object)this.aList.get(0));
        this.aList.sort(Comparator.comparingInt(value -> (Integer)value));
        Assertions.assertEquals((Object)-1, (Object)this.aList.get(0));
    }

    @Test
    void iteratorConcurrentModifications() {
        Iterator iterator = this.aList.iterator();
        this.aList.add((Object)101);
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.addAll(Arrays.asList(102, 103));
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.add(103, (Object)104);
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.addAll(104, Arrays.asList(105, 106));
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.sort(Comparator.comparingInt(value -> (Integer)value));
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.remove(105);
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.remove((Object)104);
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.removeAll(Arrays.asList(103, 102));
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.removeAll(Arrays.asList(103, 102));
        iterator.next();
        iterator = this.aList.iterator();
        this.aList.retainAll(Arrays.asList(0, 1, 2));
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = this.aList.iterator();
        this.aList.retainAll(Arrays.asList(0, 1, 2));
        iterator.next();
        iterator = this.aList.iterator();
        this.aList.clear();
        Assertions.assertThrows(ConcurrentModificationException.class, iterator::next);
    }

    @Test
    void forEach() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            list.add((Object)0);
            list.add((Object)1);
            list.add((Object)2);
            ArrayList output = new ArrayList();
            list.forEach(output::add);
            Assertions.assertEquals((Object)list, output);
        }
    }

    @Test
    void forEachNPE() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            Assertions.assertThrows(NullPointerException.class, () -> list.forEach(null));
        }
    }

    @Test
    void forEachCME() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            list.add((Object)1);
            list.add((Object)2);
            ArrayList processed = new ArrayList();
            Assertions.assertThrows(ConcurrentModificationException.class, () -> list.forEach(t -> {
                processed.add(t);
                list.add(t);
            }));
            Assertions.assertEquals((int)1, (int)processed.size());
        }
    }

    @Test
    void forEachCMEonLastElement() {
        try (HeapTrackingArrayList list = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);){
            list.add((Object)1);
            list.add((Object)2);
            list.add((Object)3);
            Assertions.assertThrows(ConcurrentModificationException.class, () -> list.forEach(t -> {
                if (t == 3) {
                    list.add(t);
                }
            }));
        }
    }
}

