/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import org.neo4j.exceptions.StoreFailureException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class NodeEntityWrappingNodeValue
extends NodeValue {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeEntityWrappingNodeValue.class) + NodeEntity.SHALLOW_SIZE;
    private final Node node;
    private volatile TextArray labels;
    private volatile MapValue properties;

    NodeEntityWrappingNodeValue(Node node) {
        super(node.getId());
        this.node = node;
    }

    public Node nodeEntity() {
        return this.node;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writeNodeReference(this.id());
        } else {
            MapValue p;
            TextArray l;
            try {
                l = this.labels();
                p = this.properties();
            }
            catch (NotFoundException e) {
                l = Values.stringArray((String[])new String[0]);
                p = VirtualValues.EMPTY_MAP;
            }
            catch (StoreFailureException e) {
                throw new ReadAndDeleteTransactionConflictException(NodeEntity.isDeletedInCurrentTransaction(this.node), (Throwable)e);
            }
            if (this.id() < 0L) {
                writer.writeVirtualNodeHack((Object)this.node);
            }
            writer.writeNode(this.node.getId(), l, p);
        }
    }

    public void populate() {
        try {
            this.labels();
            this.properties();
        }
        catch (StoreFailureException | NotFoundException throwable) {
            // empty catch block
        }
    }

    public boolean isPopulated() {
        return this.labels != null && this.properties != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextArray labels() {
        TextArray l = this.labels;
        if (l == null) {
            NodeEntityWrappingNodeValue nodeEntityWrappingNodeValue = this;
            synchronized (nodeEntityWrappingNodeValue) {
                l = this.labels;
                if (l == null) {
                    ArrayList<String> ls = new ArrayList<String>();
                    for (Label label : this.node.getLabels()) {
                        ls.add(label.name());
                    }
                    l = this.labels = Values.stringArray((String[])ls.toArray(new String[0]));
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            NodeEntityWrappingNodeValue nodeEntityWrappingNodeValue = this;
            synchronized (nodeEntityWrappingNodeValue) {
                m = this.properties;
                if (m == null) {
                    m = this.properties = ValueUtils.asMapValue(this.node.getAllProperties());
                }
            }
        }
        return m;
    }

    public long estimatedHeapUsage() {
        long size = SHALLOW_SIZE;
        if (this.labels != null) {
            size += this.labels.estimatedHeapUsage();
        }
        if (this.properties != null) {
            size += this.properties.estimatedHeapUsage();
        }
        return size;
    }
}

