/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

public class NativeDistinctValuesProgressor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexProgressor<KEY, VALUE> {
    private final IndexLayout<KEY, VALUE> layout;
    private final KEY prev;
    private final Comparator<KEY> comparator;
    private boolean first = true;
    private long countForCurrentValue;
    private boolean last;

    NativeDistinctValuesProgressor(Seeker<KEY, VALUE> seeker, IndexProgressor.EntityValueClient client, IndexLayout<KEY, VALUE> layout, Comparator<KEY> comparator) {
        super(seeker, client);
        this.layout = layout;
        this.prev = (NativeIndexKey)((Object)layout.newKey());
        this.comparator = comparator;
    }

    public boolean next() {
        try {
            while (this.seeker.next()) {
                NativeIndexKey key = (NativeIndexKey)((Object)this.seeker.key());
                if (this.first) {
                    this.first = false;
                    this.countForCurrentValue = 1L;
                    this.layout.copyKey((Object)key, this.prev);
                    continue;
                }
                if (this.comparator.compare(this.prev, (KEY)((Object)key)) == 0) {
                    ++this.countForCurrentValue;
                    continue;
                }
                boolean accepted = this.client.acceptEntity(this.countForCurrentValue, Float.NaN, this.extractValues(this.prev));
                this.countForCurrentValue = 1L;
                this.layout.copyKey((Object)key, this.prev);
                if (!accepted) continue;
                return true;
            }
            boolean finalResult = !this.first && !this.last && this.client.acceptEntity(this.countForCurrentValue, Float.NaN, this.extractValues(this.prev));
            this.last = true;
            return finalResult;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

